# Are the following vectors linearly dependent?
# [1,2,3,4], [1,-2,3,-4], [1,0,1,0]

import numpy as np

# Define the vectors
v1 = np.array([1, 2, 3, 4]); print("v1 =",v1)
v2 = np.array([1, -2, 3, -4])
v3 = np.array([1, 0, 1, 0])

# Combine them as columns into a matrix
A = np.column_stack((v1, v2, v3)); print("A =",A)

# Compute the rank
rank = np.linalg.matrix_rank(A); print("rank =",rank)

rank

# how to get # of rows and columns
print("shape(A) =",A.shape[0],A.shape[1])
