# Are the following vectors in C linearly dependent?
# [i, 1], [1 + i, 1 - i]

import numpy as np

# Define complex vectors. NB: imaginary unit=j
v1 = np.array([1j, 1])           # 1j, not j
v2 = np.array([1 + 1j, 1 - 1j])

# Combine as columns
A = np.column_stack((v1, v2)); print("A =",A)

# Compute rank over the complex field
rank = np.linalg.matrix_rank(A); print("rank =",rank)

# 1 ⇒ linearly dependent
