# Find an orthonormal basis in 3D so that (1,1,1)/sqrt(3) is one of
# its basis vectors.

import numpy as np

b1 = np.array([1,1,1])/np.sqrt(3)
b2 = np.array([1,0,0])     # any vector
b2 = b2 - (b1@b2)*b1       # @=dot product, also np.dot(,)
# b2 -= (b1@b2)*b1         # THIS IS ERROR

b2 = b2/np.linalg.norm(b2) # Euclidean norm
b3 = np.array([0,1,0])
b3 = b3 - (b1@b3)*b1-(b2@b3)*b2
b3 = b3/np.linalg.norm(b3); print("b3 =",b3)

print(b1@b3, b2@b3, b1@b2)
print(b1@b1, b2@b2, b3@b3)
