# Find an orthonormal basis in 3D so that (1,1,1)/sqrt(3) is one of
# its basis vectors.

import numpy as np

b1 = np.array([1,1j])
b1 = b1/np.linalg.norm(b1); print(b1)

b2 = np.array([1,0])        # any vector
b2 = b2 - np.vdot(b1,b2)*b1 # Hermitean product, DO NOT USE @
b2 = b2/np.linalg.norm(b2)  # = sqrt(np.vdot(b1,b2))
print(b2)

