import sympy as sp

# from sympy import *  # no need for prefix sp., overwrites names

def scal(p, q):
    x = sp.Symbol('x', real=True)
    w = sp.exp(-x**2)
    integral = sp.integrate(p * q * w, (x, -sp.oo, sp.oo))
    return sp.simplify(integral)

def norm(p):
    return sp.sqrt(scal(p,p))

x = sp.Symbol('x', real=True)

# test
n = norm(1); print(n)

b0,b1,b2,b3,b4 = sp.symbols('b0 b1 b2 b3 b4')

b0 = 1
b0 = b0/norm(b0); print("b0 =",b0)

b1 = x
b1 = b1-scal(b0,b1)*b0
b1 = b1/norm(b1); print("b1 =",b1)

b2 = x**2
b2 = b2-scal(b0,b2)*b0-scal(b1,b2)*b1
b2 = b2/norm(b2); print("b2 =",b2)

b3 = x**3
b3 = b3-scal(b0,b3)*b0-scal(b1,b3)*b1-scal(b2,b3)*b2
b3 = b3/norm(b3); print("b3 =",b3)

b4 = x**4
b4 = b4-scal(b0,b4)*b0-scal(b1,b4)*b1-scal(b2,b4)*b2-scal(b3,b4)*b3
b4 = b4/norm(b4); print(b4)

R = (x,-2,2)
sp.plot((b0,R),(b1,R),(b2,R),(b3,R),(b4,R),legend=True)

# Note: b<i> are Hermite polynomials (except normalization)
