# Write a matrix of rotation by angle α and calculate its determinant.

import sympy as sp
sp.init_printing()

α = sp.Symbol('α', real=True)

A = sp.Matrix([[sp.cos(α),-sp.sin(α)],[sp.sin(α),sp.cos(α)]])
D = A.det(); print("D =",D)   # cf. A.linalg.det(A) in numpy

D = sp.simplify(D); print("D =",D)

Ax = A.H
I = sp.simplify(A@Ax); sp.pprint(I)

