# Write a matrix of rotation by angle α and calculate its determinant.

import sympy as sp
sp.init_printing(use_unicode=True)

α, θ, φ = sp.symbols('α θ φ', real=True)
r, a, b, c = sp.symbols('r a b c', positive=True)

r = sp.sqrt(a**2+b**2+c**2)
θ = sp.acos(c/r)
φ = sp.atan2(b,a)  # atan not overloaded
# rotation by φ around z
R1 = sp.Matrix([[sp.cos(φ),-sp.sin(φ),0],[sp.sin(φ),sp.cos(φ),0],[0,0,1]]);
sp.pprint(R1)

# rotation by θ around y (note the sign - obtained from R1 by cyclic transformation x→y→z→x)
R2 = sp.Matrix([[sp.cos(θ),0,sp.sin(θ)],[0,1,0],[-sp.sin(θ),0,sp.cos(θ)]])
# rotation by α around z
R3 = sp.Matrix([[sp.cos(α),-sp.sin(α),0],[sp.sin(α),sp.cos(α),0],[0,0,1]])
# compose from right
R = R1 @ R2 @ R3 @ R2.inv() @ R1.inv()
# R = sp.simplify(R); print("R =",R)       # SLOW, PARTIAL RESULT
# test - should be unitary

# the determinant is SLOW -- please wait
D = sp.simplify(R.det()); print("D =",D)   # SLOW

# E = R.eigenvals()                        # FAILS AFTER 10 MINUTES
# eigenvalues Maple: 1, cos(α) ± i sin(α)

# test: rotate around [1, -3/2, 1/2] by π/6
Rnum = R.subs({a:1, b:-3/2, c:1/2, α:sp.pi/6})
Rnum = Rnum.evalf()
I = Rnum**12; print("I=",I) # identity matrix

# pretty print
sp.pprint(I)

# visualize vectors
import matplotlib.pyplot as plt
import numpy as np

fig = plt.figure()
ax = fig.add_subplot(111, projection='3d')

v = np.array([1,1,2/3]); print("v=",v)

for i in range(0,12):
    ax.scatter(*v, color='blue', s=30)
#    ax.quiver(0, 0, 0, *v, length=1, normalize=False, color='orange')
    v = Rnum @ v

v = np.array([0,0,0])
ax.scatter(*v, color='red', s=50)

ax.set_box_aspect([1,1,1])
plt.title("rotate 12* by π/6")
plt.show()

