# Eigenvalues and eigenvectors - matrix in R3
# • Calculate eigenvalues and eigenvectors of the symmetric matrix A given below.
# • Normalize the eigenvectors and verify that the basis is orthonormal.
# • Expand vector V =(1,1,1) into this basis.
# Verify that in the new basis the matrix is diagonal.

import numpy as np

A = np.array([[1,1,3],[1,2,-1],[3,-1,1]])
A

eigval,eigvec=np.linalg.eig(A)
eigval

# eigenvectors are columns: eigvec[:,0], eigvec[:,1], eigvec[:,2]
# (or use transpose - see below)
# ! eigvec[0] is NOT eigenvector[0] !
eigvec

# three vectors of the basis B
B = np.transpose(eigvec)
B

# the basis B is orthogonal
B[0]@B[1]; B[1]@B[2]; B[2]@B[0];

# the basis B is normalized
B[0]@B[0]; B[1]@B[1]; B[2]@B[2]

# A.v = λ.B
for i in [0,1,2]:
    print(A@B[i]-eigval[i]*B[i])


# the same using another notation
for i in [0,1,2]:
    print(A@eigvec[:,i]-eigval[i]*eigvec[:,i])


# Vector to expand to basis B
V=np.array([1,1,1])

# Coordinates of vector V in the new basis (dtype=float is important!)
b = np.zeros(3, dtype=float)
for i in [0,1,2]:
    b[i]=V@B[i]

b

# Verification that we get the original vector
Vreconstructed=b[0]*B[0]+b[1]*B[1]+b[2]*B[2]
Vreconstructed
