import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

def f(x,y):
    return x**2 - 4*x*y + y**2

# Grid
x = np.linspace(-1,1,20)
y = np.linspace(-1,1,20)
X,Y = np.meshgrid(x,y)
Z = f(X,Y)

# 3D plot
fig = plt.figure()
ax = fig.add_subplot(111, projection='3d')
ax.plot_surface(X, Y, Z, cmap='viridis')

ax.set_xlabel('x')
ax.set_ylabel('y')
ax.set_zlabel('x² − 4xy + y²');
ax.set_title('quadratic form')
plt.show()


A=np.array([[1,-2],[-2,1]])

eigval,eigvec=np.linalg.eig(A)

eigval

# eigenvectors are columns: eigvec[:,0], eigvec[:,1], eigvec[:,2]
# (or use transpose - see below)
# ! eigvec[0] is NOT eigenvector[0] !
eigvec

