# Consider two consecutive reactions of the 1st order:
#
#          k1     k2
#      A1  →  A2  →  products
#
# At reaction start (t=0), the concentrations are [A1]=c0, [A2]=0.
# Draw graphs for k1=2, k2=1, c0=1
#

import sympy as sp
sp.init_printing()

k1,k2,c0,t = sp.symbols('k1 k2 c0 t', real=True)

A1 = sp.Function('A1')(t)
A2 = sp.Function('A2')(t)
A3 = sp.Function('A3')(t)
# these include (t) in the symbol
# for declaration without (t), use:
#   A0, A1, A2 = sp.symbols('A0 A1 A2', cls=sp.Function)

eq1 = sp.Eq(sp.diff(A1,t),-k1*A1)
eq2 = sp.Eq(sp.diff(A2,t),-k2*A2+k1*A1)
eq3 = sp.Eq(sp.diff(A3,t), k2*A2)
res = sp.dsolve([eq1,eq2,eq3],
                ics={A1.subs(t,0):c0, A2.subs(t,0):0, A3.subs(t,0):0})

res

p1=res[0].rhs.subs({k2:1,k1:2,c0:1})
p2=res[1].rhs.subs({k2:1,k1:2,c0:1})
p3=res[2].rhs.subs({k2:1,k1:2,c0:1})

sp.plot(p1,p2,p3,(t,0,3),legend=True, show=True)

