# Consider two consecutive reactions of the 1st order:
#
#          k1     k2
#      A1  →  A2  →  products
#
# At reaction start (t=0), the concentrations are [A1]=c0, [A2]=0.
# Draw graphs for k1=2, k2=1, c0=1
#
# Using the general theory

import sympy as sp
sp.init_printing()

k1,k2,c0,t = sp.symbols('k1 k2 c0 t', real=True)

A=sp.Matrix([[-k1,0],[k1,-k2]])
A

# Vall is a list of triplets
Vall=A.eigenvects(); print("Vall =",Vall)

λ = [l for (l, _, _) in Vall ]; print("λ =",λ)

V = [v for (_, _, vects) in Vall for v in vects]
# the above nested loop is a shortcut for
# V = []
# for (_, _, vects) in Vall:
#     for v in vects:
#         V.append(v)

v = [ sp.exp(λ[i]*t)*V[i] for i in [0,1] ]
# v0=v.subs(t,0), but V is essentially the same thing

print(v)

C0,C1 = sp.symbols('C0 C1', real=True)

# using EXPR in solve, solveset etc. is the same as sp.Eq(EXPR,0)
# note [] and ()
res=sp.linsolve([C0*V[0][0]+C1*V[1][0]-c0, C0*V[0][1]+C1*V[1][1]], (C0,C1))
res

# res is a tuple (here 1-tuple) of lists, each containg a result
# the same as Maple assign (1st solution if more solutions)
C0,C1=list(res)[0]

Aux0=C0*v[0][0]+C1*v[1][0]; print("Aux0 =",Aux0)
Aux1=C0*v[0][1]+C1*v[1][1]; print("Aux1 =",Aux1)

# substitute numbers: using a list
A1=Aux0.subs([(c0,1),(k1,1),(k2,2)])
# as above, using a dictionary
A2=Aux1.subs({c0:1,k1:1,k2:2})

A3=(c0-A2-A1).subs(c0,1)

sp.plot(A1,A2,A3, (t,0,3), legend=True, show=True)

