#define VERSION "2.4f"
/* max 4 characters:
   from 2.3a: new GUI
   from 2.4a: .gol files removed
   first 3 chars used to check .bin file format */

/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% BLENDPAR.H

This module defines the internal representation of force field parameters
(for atoms, bonds, angles, dihedral and improper torsions) and performs
reading and writing the parameter files.
See also intrapot.h !

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

#ifndef MAXVAL
#define MAXVAL 6     /* max valence: proteins normally OK with 4,
                        you may need 6 for proteins with heme */
#endif

#define MAXPER 6 /* max periodicity (=n in cos(n*phi)) of dihedrals */
#define DEFAULTPAR "charmm21" /* default parameter set */

#ifdef POLAR
typedef struct isotropicparm_s {
  /* kappa must be 1st in both axial_t and isotropicparm_t (see blendss.c) */
  ireal kappa;  /* repulsive core parameter */
  ireal alpha;  /* [A^3] polarizability */
  ireal shell;  /* auxiliary charge for MD with polarizabilities (export only) */
  ireal Esat;   /* saturation energy: mu=alpha*El/(1+mu*El/Esat) */
  int rep;      /* the repulsive atom, normally cation to "shell-core" */
} isotropicparm_t;
#endif

extern int NATOMS;
extern struct atom_s {
  char name[6];    /* symbolic name */
  unsigned char Z; /* nuclear charge */
  char chem;       /* chemical name for colors:
                      H,N,C,O,P,S; M=metal, X=halogen, Z=rare gas */
  double mass;     /* in atomic units */
  siteparm_t LJ[2];/* LJ[0]: LJ parameters, LJ[1]: for 1-4 interactions */
                   /* for LJ_t, see lj/sitesite.h, replj/sitesite.h etc. */
                   /* NOTE: alpha in LJ is for combining rule only ! */
#ifdef POLAR
  isotropicparm_t isotropicparm;
#endif
  char no14;    /* if LJ[1]==LJ[0] (no special term for 1-4) */
  char X;       /* atom that can match wildcard atom X in tables */
  char A;       /* member of an aromatic ring */
  char used;
} *atom; /* [NATOMS] */

typedef struct sitesite_s {
  pairaux_t a; /* former SS_DECLARE */
} sitesite_t;

extern sitesite_t (**sstab)[2]; /* [site1][site2][onefour] */

extern int nbonds,nangles,ndihedrals,nimpropers,ncisdihedrals,nnbfixes;
/* it is assumed in rwbin that these are ints */

extern bond_t *bond0;
extern angle_t *angle0;
extern torsion_t *dihedral0,*improper0,*cisdihedral0;
extern nbfix_t *nbfix0;

extern int all_dihedrals,ar_dih_limit,all_impropers,column_X,comb_rule;
extern double factor14; /* to multiple 1-4 forces */
extern int distance14;  /* if !=4 then 1-distance14 interactions */
extern int polar;       /* polar=1 expected in the par-file for POLAR */
extern int ar_14_limit; /* 3 for GROMOS (no 1-4 in or at aromatic rings) */

extern int atomn_ERROR;
int atomn(char *name);

extern unsigned4 (*nbfixtab)[8];

extern char *PARfn,*blendpath;
void preparegammas(void);
void readPAR(char *fn);
int rwBIN(char *fn,char *ext);
void readPARBIN(char *fn);

char *getnoncommentline(FILE *file, char *line);

extern char *atom_f;
extern char *NBFIXexc_f;
extern char *z_f;
extern char *torsion_f, *dihedral_f, *bond_f, *angle_f;
extern char *angleUB_f;
extern char *depend_f;
extern char *outtext_f;
extern char *charge_f;
extern char *sites_f;
extern char *infoxyz_f, *infor_f, *infoa_f, *infod_f;
#ifdef POLAR
extern char *polar_f, *axial_f;
#endif
void fillprec(void);

/*** partial charges ***/

extern char *PCHname,*REAname;

extern struct partial_s {
  struct partial_s *next;
  int center;      /* central atom type */
  int nnbr;        /* # of neighbors */
  int nbr[MAXVAL]; /* atom types as bonded to center. Ordered! */
  double centerq;
  double q[MAXVAL]; /* ... charges */
} *partial0;

void readPCH(char *fn);

#define MAXWATERSITES 4
extern int nwaters;
extern struct water_s {
  struct water_s *next;
  int ns;
  double charge[MAXWATERSITES]; /* see site_t */
  int type[MAXWATERSITES];
  char name[8];
} *water0;

#ifdef POLAR
typedef struct axialparm_s {
  ireal alpha;  /* [A^3] polarizability in x and y directions */
  ireal alphazz;/* [A^3] polarizability in z direction */
  ireal Esat;   /* saturation energy: mu=alpha*El/(1+mu*El/Esat) */
} axialparm_t;

/*** NOTE
  Arrays indx[] in the following structures refer to indexes in array atom[]
  when the corresponding linked lists contain data from parameter files
  (generated by readPAR).
  Another linked lists are created in blendgen.c to be used in the force field,
  here, indx[] contains reference to the atom numbers in the respective
  molecule. (Bad programming habits...)
  ! because of special requirements of rwbin, the first two fields in bond_t,
  angle_t, torsion_t must be  next  and  index  - just like in any_t !
***/

extern int npolarbonds;
extern struct polarbond_s {
  struct polarbond_s *next;
  int indx[2];
  axialparm_t parm;
} *polarbond0;

extern int npolarangles;
extern struct polarangle_s {
  struct polarangle_s *next;
  int indx[3];
  axialparm_t parm;
} *polarangle0;

extern void scalepolarizabilities(double scalealpha,double scaleEsat);
#endif

/* bit more efficient token parsing */
extern int ntoks; /* # of tokens found so far */
extern char *tok,*toksep;

char *firsttok(char *l);
char *nexttok(void);

#ifndef TINY
/* constrained dihedrals (see MOLECULE.jet) */
typedef struct fixdih_s {
  struct fixdih_s *next;
  int indx[4];
  ireal phi;
} fixdih_t;

#define NBBTYPE 6
extern int bbdata[9][NBBTYPE];
/* bbdata[0]: dummy */
/* bbdata[1]: peptide N types */
/* bbdata[2]: Calpha types */
/* bbdata[3]: C of >C=O types */
/* bbdata[8]: O of >C=O types */
#endif

void scalebonds(void);
void scaleangles(void);
