struct utf8_s {
  char *U; /* Unicode character in #UHEX form */
  char *utf; /* the string */
  char *eq; /* ascii equivalent */
  unsigned short h; /* UTF8 equivalent */
  char *name; /* the name */
} utftab[]= {
  /* often also U+ instead of #U */
{"#U0020"," ","",0x20,"SPACE"},
{"#U0021","!","",0x21,"EXCLAMATION MARK"},
{"#U0022","\"","",0x22,"QUOTATION MARK"},
{"#U0023","#","",0x23,"NUMBER SIGN"},
{"#U0024","$","",0x24,"DOLLAR SIGN"},
{"#U0025","%","",0x25,"PERCENT SIGN"},
{"#U0026","&","",0x26,"AMPERSAND"},
{"#U0027","\'","",0x27,"APOSTROPHE"},
{"#U0028","(","",0x28,"LEFT PARENTHESIS"},
{"#U0029",")","",0x29,"RIGHT PARENTHESIS"},
{"#U002A","*","",0x2a,"ASTERISK"},
{"#U002B","+","",0x2b,"PLUS SIGN"},
{"#U002C",",","",0x2c,"COMMA"},
{"#U002D","-","",0x2d,"HYPHEN-MINUS"},
{"#U002E",".","",0x2e,"FULL STOP"},
{"#U002F","/","",0x2f,"SOLIDUS"},
{"#U0030","0","",0x30,"DIGIT ZERO"},
{"#U0031","1","",0x31,"DIGIT ONE"},
{"#U0032","2","",0x32,"DIGIT TWO"},
{"#U0033","3","",0x33,"DIGIT THREE"},
{"#U0034","4","",0x34,"DIGIT FOUR"},
{"#U0035","5","",0x35,"DIGIT FIVE"},
{"#U0036","6","",0x36,"DIGIT SIX"},
{"#U0037","7","",0x37,"DIGIT SEVEN"},
{"#U0038","8","",0x38,"DIGIT EIGHT"},
{"#U0039","9","",0x39,"DIGIT NINE"},
{"#U003A",":","",0x3a,"COLON"},
{"#U003B",";","",0x3b,"SEMICOLON"},
{"#U003C","<","",0x3c,"LESS-THAN SIGN"},
{"#U003D","=","",0x3d,"EQUALS SIGN"},
{"#U003E",">","",0x3e,"GREATER-THAN SIGN"},
{"#U003F","?","",0x3f,"QUESTION MARK"},
{"#U0040","@","",0x40,"COMMERCIAL AT"},
{"#U0041","A","",0x41,"LATIN CAPITAL LETTER A"},
{"#U0042","B","",0x42,"LATIN CAPITAL LETTER B"},
{"#U0043","C","",0x43,"LATIN CAPITAL LETTER C"},
{"#U0044","D","",0x44,"LATIN CAPITAL LETTER D"},
{"#U0045","E","",0x45,"LATIN CAPITAL LETTER E"},
{"#U0046","F","",0x46,"LATIN CAPITAL LETTER F"},
{"#U0047","G","",0x47,"LATIN CAPITAL LETTER G"},
{"#U0048","H","",0x48,"LATIN CAPITAL LETTER H"},
{"#U0049","I","",0x49,"LATIN CAPITAL LETTER I"},
{"#U004A","J","",0x4a,"LATIN CAPITAL LETTER J"},
{"#U004B","K","",0x4b,"LATIN CAPITAL LETTER K"},
{"#U004C","L","",0x4c,"LATIN CAPITAL LETTER L"},
{"#U004D","M","",0x4d,"LATIN CAPITAL LETTER M"},
{"#U004E","N","",0x4e,"LATIN CAPITAL LETTER N"},
{"#U004F","O","",0x4f,"LATIN CAPITAL LETTER O"},
{"#U0050","P","",0x50,"LATIN CAPITAL LETTER P"},
{"#U0051","Q","",0x51,"LATIN CAPITAL LETTER Q"},
{"#U0052","R","",0x52,"LATIN CAPITAL LETTER R"},
{"#U0053","S","",0x53,"LATIN CAPITAL LETTER S"},
{"#U0054","T","",0x54,"LATIN CAPITAL LETTER T"},
{"#U0055","U","",0x55,"LATIN CAPITAL LETTER U"},
{"#U0056","V","",0x56,"LATIN CAPITAL LETTER V"},
{"#U0057","W","",0x57,"LATIN CAPITAL LETTER W"},
{"#U0058","X","",0x58,"LATIN CAPITAL LETTER X"},
{"#U0059","Y","",0x59,"LATIN CAPITAL LETTER Y"},
{"#U005A","Z","",0x5a,"LATIN CAPITAL LETTER Z"},
{"#U005B","[","",0x5b,"LEFT SQUARE BRACKET"},
{"#U005C","\\","",0x5c,"REVERSE SOLIDUS"},
{"#U005D","]","",0x5d,"RIGHT SQUARE BRACKET"},
{"#U005E","^","",0x5e,"CIRCUMFLEX ACCENT"},
{"#U005F","_","",0x5f,"LOW LINE"},
{"#U0060","`","",0x60,"GRAVE ACCENT"},
{"#U0061","a","",0x61,"LATIN SMALL LETTER A"},
{"#U0062","b","",0x62,"LATIN SMALL LETTER B"},
{"#U0063","c","",0x63,"LATIN SMALL LETTER C"},
{"#U0064","d","",0x64,"LATIN SMALL LETTER D"},
{"#U0065","e","",0x65,"LATIN SMALL LETTER E"},
{"#U0066","f","",0x66,"LATIN SMALL LETTER F"},
{"#U0067","g","",0x67,"LATIN SMALL LETTER G"},
{"#U0068","h","",0x68,"LATIN SMALL LETTER H"},
{"#U0069","i","",0x69,"LATIN SMALL LETTER I"},
{"#U006A","j","",0x6a,"LATIN SMALL LETTER J"},
{"#U006B","k","",0x6b,"LATIN SMALL LETTER K"},
{"#U006C","l","",0x6c,"LATIN SMALL LETTER L"},
{"#U006D","m","",0x6d,"LATIN SMALL LETTER M"},
{"#U006E","n","",0x6e,"LATIN SMALL LETTER N"},
{"#U006F","o","",0x6f,"LATIN SMALL LETTER O"},
{"#U0070","p","",0x70,"LATIN SMALL LETTER P"},
{"#U0071","q","",0x71,"LATIN SMALL LETTER Q"},
{"#U0072","r","",0x72,"LATIN SMALL LETTER R"},
{"#U0073","s","",0x73,"LATIN SMALL LETTER S"},
{"#U0074","t","",0x74,"LATIN SMALL LETTER T"},
{"#U0075","u","",0x75,"LATIN SMALL LETTER U"},
{"#U0076","v","",0x76,"LATIN SMALL LETTER V"},
{"#U0077","w","",0x77,"LATIN SMALL LETTER W"},
{"#U0078","x","",0x78,"LATIN SMALL LETTER X"},
{"#U0079","y","",0x79,"LATIN SMALL LETTER Y"},
{"#U007A","z","",0x7a,"LATIN SMALL LETTER Z"},
{"#U007B","{","",0x7b,"LEFT CURLY BRACKET"},
{"#U007C","|","",0x7c,"VERTICAL LINE"},
{"#U007D","}","",0x7d,"RIGHT CURLY BRACKET"},
{"#U007E","~","",0x7e,"TILDE"},
{"#U00A0"," "," ",0xc2a0,"NO-BREAK SPACE"},
{"#U00A1","¡","!",0xc2a1,"INVERTED EXCLAMATION MARK"},
{"#U00A2","¢","c",0xc2a2,"CENT SIGN"},
{"#U00A3","£","L",0xc2a3,"POUND SIGN"},
{"#U00A4","¤","$",0xc2a4,"CURRENCY SIGN"},
{"#U00A5","¥","Y",0xc2a5,"YEN SIGN"},
{"#U00A6","¦","|",0xc2a6,"BROKEN BAR"},
{"#U00A7","§","S",0xc2a7,"SECTION SIGN"},
{"#U00A8","¨","",0xc2a8,"DIAERESIS"},
{"#U00A9","©","(C)",0xc2a9,"COPYRIGHT SIGN"},
{"#U00AA","ª","a",0xc2aa,"FEMININE ORDINAL INDICATOR"},
{"#U00AB","«","<<",0xc2ab,"LEFT-POINTING DOUBLE ANGLE QUOTATION MARK"},
{"#U00AC","¬","^",0xc2ac,"NOT SIGN"},
{"#U00AD","­","-",0xc2ad,"SOFT HYPHEN"},
{"#U00AE","®","(R)",0xc2ae,"REGISTERED SIGN"},
{"#U00AF","¯","-",0xc2af,"MACRON"},
{"#U00B0","°","o",0xc2b0,"DEGREE SIGN"},
{"#U00B1","±","+-",0xc2b1,"PLUS-MINUS SIGN"},
{"#U00B2","²","2",0xc2b2,"SUPERSCRIPT TWO"},
{"#U00B3","³","3",0xc2b3,"SUPERSCRIPT THREE"},
{"#U00B4","´","\'",0xc2b4,"ACUTE ACCENT"},
{"#U00B5","µ","mu",0xc2b5,"MICRO SIGN"},
{"#U00B6","¶","P",0xc2b6,"PILCROW SIGN"},
{"#U00B7","·",".",0xc2b7,"MIDDLE DOT"},
{"#U00B8","¸","",0xc2b8,"CEDILLA"},
{"#U00B9","¹","1",0xc2b9,"SUPERSCRIPT ONE"},
{"#U00BA","º","o",0xc2ba,"MASCULINE ORDINAL INDICATOR"},
{"#U00BB","»",">>",0xc2bb,"RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK"},
{"#U00BC","¼","14",0xc2bc,"VULGAR FRACTION ONE QUARTER"},
{"#U00BD","½","12",0xc2bd,"VULGAR FRACTION ONE HALF"},
{"#U00BE","¾","34",0xc2be,"VULGAR FRACTION THREE QUARTERS"},
{"#U00BF","¿","?",0xc2bf,"INVERTED QUESTION MARK"},
{"#U00C0","À","A",0xc380,"LATIN CAPITAL LETTER A WITH GRAVE"},
{"#U00C1","Á","A",0xc381,"LATIN CAPITAL LETTER A WITH ACUTE"},
{"#U00C2","Â","A",0xc382,"LATIN CAPITAL LETTER A WITH CIRCUMFLEX"},
{"#U00C3","Ã","A",0xc383,"LATIN CAPITAL LETTER A WITH TILDE"},
{"#U00C4","Ä","A",0xc384,"LATIN CAPITAL LETTER A WITH DIAERESIS"},
{"#U00C5","Å","A",0xc385,"LATIN CAPITAL LETTER A WITH RING ABOVE"},
{"#U00C6","Æ","AE",0xc386,"LATIN CAPITAL LETTER AE"},
{"#U00C7","Ç","C",0xc387,"LATIN CAPITAL LETTER C WITH CEDILLA"},
{"#U00C8","È","E",0xc388,"LATIN CAPITAL LETTER E WITH GRAVE"},
{"#U00C9","É","E",0xc389,"LATIN CAPITAL LETTER E WITH ACUTE"},
{"#U00CA","Ê","E",0xc38a,"LATIN CAPITAL LETTER E WITH CIRCUMFLEX"},
{"#U00CB","Ë","E",0xc38b,"LATIN CAPITAL LETTER E WITH DIAERESIS"},
{"#U00CC","Ì","I",0xc38c,"LATIN CAPITAL LETTER I WITH GRAVE"},
{"#U00CD","Í","I",0xc38d,"LATIN CAPITAL LETTER I WITH ACUTE"},
{"#U00CE","Î","I",0xc38e,"LATIN CAPITAL LETTER I WITH CIRCUMFLEX"},
{"#U00CF","Ï","I",0xc38f,"LATIN CAPITAL LETTER I WITH DIAERESIS"},
{"#U00D0","Ð","D",0xc390,"LATIN CAPITAL LETTER ETH"},
{"#U00D1","Ñ","N",0xc391,"LATIN CAPITAL LETTER N WITH TILDE"},
{"#U00D2","Ò","O",0xc392,"LATIN CAPITAL LETTER O WITH GRAVE"},
{"#U00D3","Ó","O",0xc393,"LATIN CAPITAL LETTER O WITH ACUTE"},
{"#U00D4","Ô","O",0xc394,"LATIN CAPITAL LETTER O WITH CIRCUMFLEX"},
{"#U00D5","Õ","O",0xc395,"LATIN CAPITAL LETTER O WITH TILDE"},
{"#U00D6","Ö","O",0xc396,"LATIN CAPITAL LETTER O WITH DIAERESIS"},
{"#U00D7","×","x",0xc397,"MULTIPLICATION SIGN"},
{"#U00D8","Ø","O",0xc398,"LATIN CAPITAL LETTER O WITH STROKE"},
{"#U00D9","Ù","U",0xc399,"LATIN CAPITAL LETTER U WITH GRAVE"},
{"#U00DA","Ú","U",0xc39a,"LATIN CAPITAL LETTER U WITH ACUTE"},
{"#U00DB","Û","U",0xc39b,"LATIN CAPITAL LETTER U WITH CIRCUMFLEX"},
{"#U00DC","Ü","U",0xc39c,"LATIN CAPITAL LETTER U WITH DIAERESIS"},
{"#U00DD","Ý","Y",0xc39d,"LATIN CAPITAL LETTER Y WITH ACUTE"},
{"#U00DE","Þ","b",0xc39e,"LATIN CAPITAL LETTER THORN"},
{"#U00DF","ß","ss",0xc39f,"LATIN SMALL LETTER SHARP S"},
{"#U00E0","à","a",0xc3a0,"LATIN SMALL LETTER A WITH GRAVE"},
{"#U00E1","á","a",0xc3a1,"LATIN SMALL LETTER A WITH ACUTE"},
{"#U00E2","â","a",0xc3a2,"LATIN SMALL LETTER A WITH CIRCUMFLEX"},
{"#U00E3","ã","a",0xc3a3,"LATIN SMALL LETTER A WITH TILDE"},
{"#U00E4","ä","a",0xc3a4,"LATIN SMALL LETTER A WITH DIAERESIS"},
{"#U00E5","å","a",0xc3a5,"LATIN SMALL LETTER A WITH RING ABOVE"},
{"#U00E6","æ","ae",0xc3a6,"LATIN SMALL LETTER AE"},
{"#U00E7","ç","c",0xc3a7,"LATIN SMALL LETTER C WITH CEDILLA"},
{"#U00E8","è","e",0xc3a8,"LATIN SMALL LETTER E WITH GRAVE"},
{"#U00E9","é","e",0xc3a9,"LATIN SMALL LETTER E WITH ACUTE"},
{"#U00EA","ê","e",0xc3aa,"LATIN SMALL LETTER E WITH CIRCUMFLEX"},
{"#U00EB","ë","e",0xc3ab,"LATIN SMALL LETTER E WITH DIAERESIS"},
{"#U00EC","ì","i",0xc3ac,"LATIN SMALL LETTER I WITH GRAVE"},
{"#U00ED","í","i",0xc3ad,"LATIN SMALL LETTER I WITH ACUTE"},
{"#U00EE","î","i",0xc3ae,"LATIN SMALL LETTER I WITH CIRCUMFLEX"},
{"#U00EF","ï","i",0xc3af,"LATIN SMALL LETTER I WITH DIAERESIS"},
{"#U00F0","ð","o",0xc3b0,"LATIN SMALL LETTER ETH"},
{"#U00F1","ñ","n",0xc3b1,"LATIN SMALL LETTER N WITH TILDE"},
{"#U00F2","ò","o",0xc3b2,"LATIN SMALL LETTER O WITH GRAVE"},
{"#U00F3","ó","o",0xc3b3,"LATIN SMALL LETTER O WITH ACUTE"},
{"#U00F4","ô","o",0xc3b4,"LATIN SMALL LETTER O WITH CIRCUMFLEX"},
{"#U00F5","õ","o",0xc3b5,"LATIN SMALL LETTER O WITH TILDE"},
{"#U00F6","ö","o",0xc3b6,"LATIN SMALL LETTER O WITH DIAERESIS"},
{"#U00F7","÷",":",0xc3b7,"DIVISION SIGN"},
{"#U00F8","ø","o",0xc3b8,"LATIN SMALL LETTER O WITH STROKE"},
{"#U00F9","ù","u",0xc3b9,"LATIN SMALL LETTER U WITH GRAVE"},
{"#U00FA","ú","u",0xc3ba,"LATIN SMALL LETTER U WITH ACUTE"},
{"#U00FB","û","u",0xc3bb,"LATIN SMALL LETTER U WITH CIRCUMFLEX"},
{"#U00FC","ü","u",0xc3bc,"LATIN SMALL LETTER U WITH DIAERESIS"},
{"#U00FD","ý","y",0xc3bd,"LATIN SMALL LETTER Y WITH ACUTE"},
{"#U00FE","þ","b",0xc3be,"LATIN SMALL LETTER THORN"},
{"#U00FF","ÿ","y",0xc3bf,"LATIN SMALL LETTER Y WITH DIAERESIS"},
{"#U0100","Ā","A",0xc480,"LATIN CAPITAL LETTER A WITH MACRON"},
{"#U0101","ā","a",0xc481,"LATIN SMALL LETTER A WITH MACRON"},
{"#U0102","Ă","A",0xc482,"LATIN CAPITAL LETTER A WITH BREVE"},
{"#U0103","ă","a",0xc483,"LATIN SMALL LETTER A WITH BREVE"},
{"#U0104","Ą","A",0xc484,"LATIN CAPITAL LETTER A WITH OGONEK"},
{"#U0105","ą","a",0xc485,"LATIN SMALL LETTER A WITH OGONEK"},
{"#U0106","Ć","C",0xc486,"LATIN CAPITAL LETTER C WITH ACUTE"},
{"#U0107","ć","c",0xc487,"LATIN SMALL LETTER C WITH ACUTE"},
{"#U0108","Ĉ","C",0xc488,"LATIN CAPITAL LETTER C WITH CIRCUMFLEX"},
{"#U0109","ĉ","c",0xc489,"LATIN SMALL LETTER C WITH CIRCUMFLEX"},
{"#U010A","Ċ","C",0xc48a,"LATIN CAPITAL LETTER C WITH DOT ABOVE"},
{"#U010B","ċ","c",0xc48b,"LATIN SMALL LETTER C WITH DOT ABOVE"},
{"#U010C","Č","C",0xc48c,"LATIN CAPITAL LETTER C WITH CARON"},
{"#U010D","č","c",0xc48d,"LATIN SMALL LETTER C WITH CARON"},
{"#U010E","Ď","D",0xc48e,"LATIN CAPITAL LETTER D WITH CARON"},
{"#U010F","ď","d",0xc48f,"LATIN SMALL LETTER D WITH CARON"},
{"#U0110","Đ","D",0xc490,"LATIN CAPITAL LETTER D WITH STROKE"},
{"#U0111","đ","d",0xc491,"LATIN SMALL LETTER D WITH STROKE"},
{"#U0112","Ē","E",0xc492,"LATIN CAPITAL LETTER E WITH MACRON"},
{"#U0113","ē","e",0xc493,"LATIN SMALL LETTER E WITH MACRON"},
{"#U0114","Ĕ","E",0xc494,"LATIN CAPITAL LETTER E WITH BREVE"},
{"#U0115","ĕ","e",0xc495,"LATIN SMALL LETTER E WITH BREVE"},
{"#U0116","Ė","E",0xc496,"LATIN CAPITAL LETTER E WITH DOT ABOVE"},
{"#U0117","ė","e",0xc497,"LATIN SMALL LETTER E WITH DOT ABOVE"},
{"#U0118","Ę","E",0xc498,"LATIN CAPITAL LETTER E WITH OGONEK"},
{"#U0119","ę","e",0xc499,"LATIN SMALL LETTER E WITH OGONEK"},
{"#U011A","Ě","E",0xc49a,"LATIN CAPITAL LETTER E WITH CARON"},
{"#U011B","ě","e",0xc49b,"LATIN SMALL LETTER E WITH CARON"},
{"#U011C","Ĝ","G",0xc49c,"LATIN CAPITAL LETTER G WITH CIRCUMFLEX"},
{"#U011D","ĝ","g",0xc49d,"LATIN SMALL LETTER G WITH CIRCUMFLEX"},
{"#U011E","Ğ","G",0xc49e,"LATIN CAPITAL LETTER G WITH BREVE"},
{"#U011F","ğ","g",0xc49f,"LATIN SMALL LETTER G WITH BREVE"},
{"#U0120","Ġ","G",0xc4a0,"LATIN CAPITAL LETTER G WITH DOT ABOVE"},
{"#U0121","ġ","g",0xc4a1,"LATIN SMALL LETTER G WITH DOT ABOVE"},
{"#U0122","Ģ","G",0xc4a2,"LATIN CAPITAL LETTER G WITH CEDILLA"},
{"#U0123","ģ","g",0xc4a3,"LATIN SMALL LETTER G WITH CEDILLA"},
{"#U0124","Ĥ","H",0xc4a4,"LATIN CAPITAL LETTER H WITH CIRCUMFLEX"},
{"#U0125","ĥ","h",0xc4a5,"LATIN SMALL LETTER H WITH CIRCUMFLEX"},
{"#U0126","Ħ","H",0xc4a6,"LATIN CAPITAL LETTER H WITH STROKE"},
{"#U0127","ħ","h",0xc4a7,"LATIN SMALL LETTER H WITH STROKE"},
{"#U0128","Ĩ","I",0xc4a8,"LATIN CAPITAL LETTER I WITH TILDE"},
{"#U0129","ĩ","i",0xc4a9,"LATIN SMALL LETTER I WITH TILDE"},
{"#U012A","Ī","I",0xc4aa,"LATIN CAPITAL LETTER I WITH MACRON"},
{"#U012B","ī","i",0xc4ab,"LATIN SMALL LETTER I WITH MACRON"},
{"#U012C","Ĭ","I",0xc4ac,"LATIN CAPITAL LETTER I WITH BREVE"},
{"#U012D","ĭ","i",0xc4ad,"LATIN SMALL LETTER I WITH BREVE"},
{"#U012E","Į","I",0xc4ae,"LATIN CAPITAL LETTER I WITH OGONEK"},
{"#U012F","į","i",0xc4af,"LATIN SMALL LETTER I WITH OGONEK"},
{"#U0130","İ","I",0xc4b0,"LATIN CAPITAL LETTER I WITH DOT ABOVE"},
{"#U0131","ı","i",0xc4b1,"LATIN SMALL LETTER DOTLESS I"},
{"#U0132","Ĳ","IJ",0xc4b2,"LATIN CAPITAL LIGATURE IJ"},
{"#U0133","ĳ","ij",0xc4b3,"LATIN SMALL LIGATURE IJ"},
{"#U0134","Ĵ","J",0xc4b4,"LATIN CAPITAL LETTER J WITH CIRCUMFLEX"},
{"#U0135","ĵ","j",0xc4b5,"LATIN SMALL LETTER J WITH CIRCUMFLEX"},
{"#U0136","Ķ","K",0xc4b6,"LATIN CAPITAL LETTER K WITH CEDILLA"},
{"#U0137","ķ","k",0xc4b7,"LATIN SMALL LETTER K WITH CEDILLA"},
{"#U0138","ĸ","k",0xc4b8,"LATIN SMALL LETTER KRA"},
{"#U0139","Ĺ","L",0xc4b9,"LATIN CAPITAL LETTER L WITH ACUTE"},
{"#U013A","ĺ","l",0xc4ba,"LATIN SMALL LETTER L WITH ACUTE"},
{"#U013B","Ļ","L",0xc4bb,"LATIN CAPITAL LETTER L WITH CEDILLA"},
{"#U013C","ļ","l",0xc4bc,"LATIN SMALL LETTER L WITH CEDILLA"},
{"#U013D","Ľ","L",0xc4bd,"LATIN CAPITAL LETTER L WITH CARON"},
{"#U013E","ľ","l",0xc4be,"LATIN SMALL LETTER L WITH CARON"},
{"#U013F","Ŀ","L",0xc4bf,"LATIN CAPITAL LETTER L WITH MIDDLE DOT"},
{"#U0140","ŀ","l",0xc580,"LATIN SMALL LETTER L WITH MIDDLE DOT"},
{"#U0141","Ł","L",0xc581,"LATIN CAPITAL LETTER L WITH STROKE"},
{"#U0142","ł","l",0xc582,"LATIN SMALL LETTER L WITH STROKE"},
{"#U0143","Ń","N",0xc583,"LATIN CAPITAL LETTER N WITH ACUTE"},
{"#U0144","ń","n",0xc584,"LATIN SMALL LETTER N WITH ACUTE"},
{"#U0145","Ņ","N",0xc585,"LATIN CAPITAL LETTER N WITH CEDILLA"},
{"#U0146","ņ","n",0xc586,"LATIN SMALL LETTER N WITH CEDILLA"},
{"#U0147","Ň","N",0xc587,"LATIN CAPITAL LETTER N WITH CARON"},
{"#U0148","ň","n",0xc588,"LATIN SMALL LETTER N WITH CARON"},
{"#U0149","ŉ","n",0xc589,"LATIN SMALL LETTER N PRECEDED BY APOSTROPHE"},
{"#U014A","Ŋ","N",0xc58a,"LATIN CAPITAL LETTER ENG"},
{"#U014B","ŋ","n",0xc58b,"LATIN SMALL LETTER ENG"},
{"#U014C","Ō","O",0xc58c,"LATIN CAPITAL LETTER O WITH MACRON"},
{"#U014D","ō","o",0xc58d,"LATIN SMALL LETTER O WITH MACRON"},
{"#U014E","Ŏ","O",0xc58e,"LATIN CAPITAL LETTER O WITH BREVE"},
{"#U014F","ŏ","o",0xc58f,"LATIN SMALL LETTER O WITH BREVE"},
{"#U0150","Ő","O",0xc590,"LATIN CAPITAL LETTER O WITH DOUBLE ACUTE"},
{"#U0151","ő","o",0xc591,"LATIN SMALL LETTER O WITH DOUBLE ACUTE"},
{"#U0152","Œ","OE",0xc592,"LATIN CAPITAL LIGATURE OE"},
{"#U0153","œ","oe",0xc593,"LATIN SMALL LIGATURE OE"},
{"#U0154","Ŕ","R",0xc594,"LATIN CAPITAL LETTER R WITH ACUTE"},
{"#U0155","ŕ","r",0xc595,"LATIN SMALL LETTER R WITH ACUTE"},
{"#U0156","Ŗ","R",0xc596,"LATIN CAPITAL LETTER R WITH CEDILLA"},
{"#U0157","ŗ","r",0xc597,"LATIN SMALL LETTER R WITH CEDILLA"},
{"#U0158","Ř","R",0xc598,"LATIN CAPITAL LETTER R WITH CARON"},
{"#U0159","ř","r",0xc599,"LATIN SMALL LETTER R WITH CARON"},
{"#U015A","Ś","S",0xc59a,"LATIN CAPITAL LETTER S WITH ACUTE"},
{"#U015B","ś","s",0xc59b,"LATIN SMALL LETTER S WITH ACUTE"},
{"#U015C","Ŝ","S",0xc59c,"LATIN CAPITAL LETTER S WITH CIRCUMFLEX"},
{"#U015D","ŝ","s",0xc59d,"LATIN SMALL LETTER S WITH CIRCUMFLEX"},
{"#U015E","Ş","S",0xc59e,"LATIN CAPITAL LETTER S WITH CEDILLA"},
{"#U015F","ş","s",0xc59f,"LATIN SMALL LETTER S WITH CEDILLA"},
{"#U0160","Š","S",0xc5a0,"LATIN CAPITAL LETTER S WITH CARON"},
{"#U0161","š","s",0xc5a1,"LATIN SMALL LETTER S WITH CARON"},
{"#U0162","Ţ","T",0xc5a2,"LATIN CAPITAL LETTER T WITH CEDILLA"},
{"#U0163","ţ","t",0xc5a3,"LATIN SMALL LETTER T WITH CEDILLA"},
{"#U0164","Ť","T",0xc5a4,"LATIN CAPITAL LETTER T WITH CARON"},
{"#U0165","ť","t",0xc5a5,"LATIN SMALL LETTER T WITH CARON"},
{"#U0166","Ŧ","T",0xc5a6,"LATIN CAPITAL LETTER T WITH STROKE"},
{"#U0167","ŧ","t",0xc5a7,"LATIN SMALL LETTER T WITH STROKE"},
{"#U0168","Ũ","U",0xc5a8,"LATIN CAPITAL LETTER U WITH TILDE"},
{"#U0169","ũ","u",0xc5a9,"LATIN SMALL LETTER U WITH TILDE"},
{"#U016A","Ū","U",0xc5aa,"LATIN CAPITAL LETTER U WITH MACRON"},
{"#U016B","ū","u",0xc5ab,"LATIN SMALL LETTER U WITH MACRON"},
{"#U016C","Ŭ","U",0xc5ac,"LATIN CAPITAL LETTER U WITH BREVE"},
{"#U016D","ŭ","u",0xc5ad,"LATIN SMALL LETTER U WITH BREVE"},
{"#U016E","Ů","U",0xc5ae,"LATIN CAPITAL LETTER U WITH RING ABOVE"},
{"#U016F","ů","u",0xc5af,"LATIN SMALL LETTER U WITH RING ABOVE"},
{"#U0170","Ű","U",0xc5b0,"LATIN CAPITAL LETTER U WITH DOUBLE ACUTE"},
{"#U0171","ű","u",0xc5b1,"LATIN SMALL LETTER U WITH DOUBLE ACUTE"},
{"#U0172","Ų","U",0xc5b2,"LATIN CAPITAL LETTER U WITH OGONEK"},
{"#U0173","ų","u",0xc5b3,"LATIN SMALL LETTER U WITH OGONEK"},
{"#U0174","Ŵ","W",0xc5b4,"LATIN CAPITAL LETTER W WITH CIRCUMFLEX"},
{"#U0175","ŵ","w",0xc5b5,"LATIN SMALL LETTER W WITH CIRCUMFLEX"},
{"#U0176","Ŷ","Y",0xc5b6,"LATIN CAPITAL LETTER Y WITH CIRCUMFLEX"},
{"#U0177","ŷ","y",0xc5b7,"LATIN SMALL LETTER Y WITH CIRCUMFLEX"},
{"#U0178","Ÿ","Y",0xc5b8,"LATIN CAPITAL LETTER Y WITH DIAERESIS"},
{"#U0179","Ź","Z",0xc5b9,"LATIN CAPITAL LETTER Z WITH ACUTE"},
{"#U017A","ź","z",0xc5ba,"LATIN SMALL LETTER Z WITH ACUTE"},
{"#U017B","Ż","Z",0xc5bb,"LATIN CAPITAL LETTER Z WITH DOT ABOVE"},
{"#U017C","ż","z",0xc5bc,"LATIN SMALL LETTER Z WITH DOT ABOVE"},
{"#U017D","Ž","Z",0xc5bd,"LATIN CAPITAL LETTER Z WITH CARON"},
{"#U017E","ž","z",0xc5be,"LATIN SMALL LETTER Z WITH CARON"},
{"#U017F","ſ","s",0xc5bf,"LATIN SMALL LETTER LONG S"},
{"#U0180","ƀ","b",0xc680,"LATIN SMALL LETTER B WITH STROKE"},
{"#U0181","Ɓ","B",0xc681,"LATIN CAPITAL LETTER B WITH HOOK"},
{"#U0182","Ƃ","B",0xc682,"LATIN CAPITAL LETTER B WITH TOPBAR"},
{"#U0183","ƃ","b",0xc683,"LATIN SMALL LETTER B WITH TOPBAR"},
{"#U0184","Ƅ","6",0xc684,"LATIN CAPITAL LETTER TONE SIX"},
{"#U0185","ƅ","6",0xc685,"LATIN SMALL LETTER TONE SIX"},
{"#U0186","Ɔ","O",0xc686,"LATIN CAPITAL LETTER OPEN O"},
{"#U0187","Ƈ","C",0xc687,"LATIN CAPITAL LETTER C WITH HOOK"},
{"#U0188","ƈ","c",0xc688,"LATIN SMALL LETTER C WITH HOOK"},
{"#U0189","Ɖ","D",0xc689,"LATIN CAPITAL LETTER AFRICAN D"},
{"#U018A","Ɗ","D",0xc68a,"LATIN CAPITAL LETTER D WITH HOOK"},
{"#U018B","Ƌ","D",0xc68b,"LATIN CAPITAL LETTER D WITH TOPBAR"},
{"#U018C","ƌ","d",0xc68c,"LATIN SMALL LETTER D WITH TOPBAR"},
{"#U018D","ƍ","d",0xc68d,"LATIN SMALL LETTER TURNED DELTA"},
{"#U018E","Ǝ","E",0xc68e,"LATIN CAPITAL LETTER REVERSED E"},
{"#U018F","Ə","s",0xc68f,"LATIN CAPITAL LETTER SCHWA"},
{"#U0190","Ɛ","E",0xc690,"LATIN CAPITAL LETTER OPEN E"},
{"#U0191","Ƒ","F",0xc691,"LATIN CAPITAL LETTER F WITH HOOK"},
{"#U0192","ƒ","f",0xc692,"LATIN SMALL LETTER F WITH HOOK"},
{"#U0193","Ɠ","G",0xc693,"LATIN CAPITAL LETTER G WITH HOOK"},
{"#U0194","Ɣ","g",0xc694,"LATIN CAPITAL LETTER GAMMA"},
{"#U0195","ƕ","hv",0xc695,"LATIN SMALL LETTER HV"},
{"#U0196","Ɩ","i",0xc696,"LATIN CAPITAL LETTER IOTA"},
{"#U0197","Ɨ","I",0xc697,"LATIN CAPITAL LETTER I WITH STROKE"},
{"#U0198","Ƙ","K",0xc698,"LATIN CAPITAL LETTER K WITH HOOK"},
{"#U0199","ƙ","k",0xc699,"LATIN SMALL LETTER K WITH HOOK"},
{"#U019A","ƚ","l",0xc69a,"LATIN SMALL LETTER L WITH BAR"},
{"#U019B","ƛ","l",0xc69b,"LATIN SMALL LETTER LAMBDA WITH STROKE"},
{"#U019C","Ɯ","M",0xc69c,"LATIN CAPITAL LETTER TURNED M"},
{"#U019D","Ɲ","N",0xc69d,"LATIN CAPITAL LETTER N WITH LEFT HOOK"},
{"#U019E","ƞ","n",0xc69e,"LATIN SMALL LETTER N WITH LONG RIGHT LEG"},
{"#U019F","Ɵ","O",0xc69f,"LATIN CAPITAL LETTER O WITH MIDDLE TILDE"},
{"#U01A0","Ơ","O",0xc6a0,"LATIN CAPITAL LETTER O WITH HORN"},
{"#U01A1","ơ","o",0xc6a1,"LATIN SMALL LETTER O WITH HORN"},
{"#U01A2","Ƣ","OI",0xc6a2,"LATIN CAPITAL LETTER OI"},
{"#U01A3","ƣ","oi",0xc6a3,"LATIN SMALL LETTER OI"},
{"#U01A4","Ƥ","P",0xc6a4,"LATIN CAPITAL LETTER P WITH HOOK"},
{"#U01A5","ƥ","p",0xc6a5,"LATIN SMALL LETTER P WITH HOOK"},
{"#U01A6","Ʀ","yr",0xc6a6,"LATIN LETTER YR"},
{"#U01A7","Ƨ","2",0xc6a7,"LATIN CAPITAL LETTER TONE TWO"},
{"#U01A8","ƨ","2",0xc6a8,"LATIN SMALL LETTER TONE TWO"},
{"#U01A9","Ʃ","S",0xc6a9,"LATIN CAPITAL LETTER ESH"},
{"#U01AA","ƪ","s",0xc6aa,"LATIN LETTER REVERSED ESH LOOP"},
{"#U01AB","ƫ","t",0xc6ab,"LATIN SMALL LETTER T WITH PALATAL HOOK"},
{"#U01AC","Ƭ","T",0xc6ac,"LATIN CAPITAL LETTER T WITH HOOK"},
{"#U01AD","ƭ","t",0xc6ad,"LATIN SMALL LETTER T WITH HOOK"},
{"#U01AE","Ʈ","T",0xc6ae,"LATIN CAPITAL LETTER T WITH RETROFLEX HOOK"},
{"#U01AF","Ư","U",0xc6af,"LATIN CAPITAL LETTER U WITH HORN"},
{"#U01B0","ư","u",0xc6b0,"LATIN SMALL LETTER U WITH HORN"},
{"#U01B1","Ʊ","U",0xc6b1,"LATIN CAPITAL LETTER UPSILON"},
{"#U01B2","Ʋ","V",0xc6b2,"LATIN CAPITAL LETTER V WITH HOOK"},
{"#U01B3","Ƴ","Y",0xc6b3,"LATIN CAPITAL LETTER Y WITH HOOK"},
{"#U01B4","ƴ","y",0xc6b4,"LATIN SMALL LETTER Y WITH HOOK"},
{"#U01B5","Ƶ","Z",0xc6b5,"LATIN CAPITAL LETTER Z WITH STROKE"},
{"#U01B6","ƶ","z",0xc6b6,"LATIN SMALL LETTER Z WITH STROKE"},
{"#U01B7","Ʒ","EZH",0xc6b7,"LATIN CAPITAL LETTER EZH"},
{"#U01B8","Ƹ","EZH",0xc6b8,"LATIN CAPITAL LETTER EZH REVERSED"},
{"#U01B9","ƹ","ezh",0xc6b9,"LATIN SMALL LETTER EZH REVERSED"},
{"#U01BA","ƺ","ezh",0xc6ba,"LATIN SMALL LETTER EZH WITH TAIL"},
{"#U01BB","ƻ","2",0xc6bb,"LATIN LETTER TWO WITH STROKE"},
{"#U01BC","Ƽ","5",0xc6bc,"LATIN CAPITAL LETTER TONE FIVE"},
{"#U01BD","ƽ","5",0xc6bd,"LATIN SMALL LETTER TONE FIVE"},
{"#U01BE","ƾ","`",0xc6be,"LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE"},
{"#U01BF","ƿ","p",0xc6bf,"LATIN LETTER WYNN"},
{"#U01C0","ǀ","|",0xc780,"LATIN LETTER DENTAL CLICK"},
{"#U01C1","ǁ","||",0xc781,"LATIN LETTER LATERAL CLICK"},
{"#U01C2","ǂ","+",0xc782,"LATIN LETTER ALVEOLAR CLICK"},
{"#U01C3","ǃ","!",0xc783,"LATIN LETTER RETROFLEX CLICK"},
{"#U01C4","Ǆ","DZ",0xc784,"LATIN CAPITAL LETTER DZ WITH CARON"},
{"#U01C5","ǅ","Dz",0xc785,"LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON"},
{"#U01C6","ǆ","dz",0xc786,"LATIN SMALL LETTER DZ WITH CARON"},
{"#U01C7","Ǉ","LJ",0xc787,"LATIN CAPITAL LETTER LJ"},
{"#U01C8","ǈ","Lj",0xc788,"LATIN CAPITAL LETTER L WITH SMALL LETTER J"},
{"#U01C9","ǉ","lj",0xc789,"LATIN SMALL LETTER LJ"},
{"#U01CA","Ǌ","NJ",0xc78a,"LATIN CAPITAL LETTER NJ"},
{"#U01CB","ǋ","Nj",0xc78b,"LATIN CAPITAL LETTER N WITH SMALL LETTER J"},
{"#U01CC","ǌ","nj",0xc78c,"LATIN SMALL LETTER NJ"},
{"#U01CD","Ǎ","A",0xc78d,"LATIN CAPITAL LETTER A WITH CARON"},
{"#U01CE","ǎ","a",0xc78e,"LATIN SMALL LETTER A WITH CARON"},
{"#U01CF","Ǐ","I",0xc78f,"LATIN CAPITAL LETTER I WITH CARON"},
{"#U01D0","ǐ","i",0xc790,"LATIN SMALL LETTER I WITH CARON"},
{"#U01D1","Ǒ","O",0xc791,"LATIN CAPITAL LETTER O WITH CARON"},
{"#U01D2","ǒ","o",0xc792,"LATIN SMALL LETTER O WITH CARON"},
{"#U01D3","Ǔ","U",0xc793,"LATIN CAPITAL LETTER U WITH CARON"},
{"#U01D4","ǔ","u",0xc794,"LATIN SMALL LETTER U WITH CARON"},
{"#U01D5","Ǖ","U",0xc795,"LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON"},
{"#U01D6","ǖ","u",0xc796,"LATIN SMALL LETTER U WITH DIAERESIS AND MACRON"},
{"#U01D7","Ǘ","U",0xc797,"LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE"},
{"#U01D8","ǘ","u",0xc798,"LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE"},
{"#U01D9","Ǚ","U",0xc799,"LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON"},
{"#U01DA","ǚ","u",0xc79a,"LATIN SMALL LETTER U WITH DIAERESIS AND CARON"},
{"#U01DB","Ǜ","U",0xc79b,"LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE"},
{"#U01DC","ǜ","u",0xc79c,"LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE"},
{"#U01DD","ǝ","e",0xc79d,"LATIN SMALL LETTER TURNED E"},
{"#U01DE","Ǟ","A",0xc79e,"LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON"},
{"#U01DF","ǟ","a",0xc79f,"LATIN SMALL LETTER A WITH DIAERESIS AND MACRON"},
{"#U01E0","Ǡ","A",0xc7a0,"LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON"},
{"#U01E1","ǡ","a",0xc7a1,"LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON"},
{"#U01E2","Ǣ","AE",0xc7a2,"LATIN CAPITAL LETTER AE WITH MACRON"},
{"#U01E3","ǣ","ae",0xc7a3,"LATIN SMALL LETTER AE WITH MACRON"},
{"#U01E4","Ǥ","G",0xc7a4,"LATIN CAPITAL LETTER G WITH STROKE"},
{"#U01E5","ǥ","g",0xc7a5,"LATIN SMALL LETTER G WITH STROKE"},
{"#U01E6","Ǧ","G",0xc7a6,"LATIN CAPITAL LETTER G WITH CARON"},
{"#U01E7","ǧ","g",0xc7a7,"LATIN SMALL LETTER G WITH CARON"},
{"#U01E8","Ǩ","K",0xc7a8,"LATIN CAPITAL LETTER K WITH CARON"},
{"#U01E9","ǩ","k",0xc7a9,"LATIN SMALL LETTER K WITH CARON"},
{"#U01EA","Ǫ","O",0xc7aa,"LATIN CAPITAL LETTER O WITH OGONEK"},
{"#U01EB","ǫ","o",0xc7ab,"LATIN SMALL LETTER O WITH OGONEK"},
{"#U01EC","Ǭ","O",0xc7ac,"LATIN CAPITAL LETTER O WITH OGONEK AND MACRON"},
{"#U01ED","ǭ","o",0xc7ad,"LATIN SMALL LETTER O WITH OGONEK AND MACRON"},
{"#U01EE","Ǯ","EZH",0xc7ae,"LATIN CAPITAL LETTER EZH WITH CARON"},
{"#U01EF","ǯ","ezh",0xc7af,"LATIN SMALL LETTER EZH WITH CARON"},
{"#U01F0","ǰ","j",0xc7b0,"LATIN SMALL LETTER J WITH CARON"},
{"#U01F1","Ǳ","DZ",0xc7b1,"LATIN CAPITAL LETTER DZ"},
{"#U01F2","ǲ","Dz",0xc7b2,"LATIN CAPITAL LETTER D WITH SMALL LETTER Z"},
{"#U01F3","ǳ","dz",0xc7b3,"LATIN SMALL LETTER DZ"},
{"#U01F4","Ǵ","G",0xc7b4,"LATIN CAPITAL LETTER G WITH ACUTE"},
{"#U01F5","ǵ","g",0xc7b5,"LATIN SMALL LETTER G WITH ACUTE"},
{"#U01F6","Ƕ","H",0xc7b6,"LATIN CAPITAL LETTER HWAIR"},
{"#U01F7","Ƿ","P",0xc7b7,"LATIN CAPITAL LETTER WYNN"},
{"#U01F8","Ǹ","N",0xc7b8,"LATIN CAPITAL LETTER N WITH GRAVE"},
{"#U01F9","ǹ","n",0xc7b9,"LATIN SMALL LETTER N WITH GRAVE"},
{"#U01FA","Ǻ","A",0xc7ba,"LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE"},
{"#U01FB","ǻ","a",0xc7bb,"LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE"},
{"#U01FC","Ǽ","AE",0xc7bc,"LATIN CAPITAL LETTER AE WITH ACUTE"},
{"#U01FD","ǽ","ae",0xc7bd,"LATIN SMALL LETTER AE WITH ACUTE"},
{"#U01FE","Ǿ","O",0xc7be,"LATIN CAPITAL LETTER O WITH STROKE AND ACUTE"},
{"#U01FF","ǿ","o",0xc7bf,"LATIN SMALL LETTER O WITH STROKE AND ACUTE"},
{"#U0200","Ȁ","A",0xc880,"LATIN CAPITAL LETTER A WITH DOUBLE GRAVE"},
{"#U0201","ȁ","a",0xc881,"LATIN SMALL LETTER A WITH DOUBLE GRAVE"},
{"#U0202","Ȃ","A",0xc882,"LATIN CAPITAL LETTER A WITH INVERTED BREVE"},
{"#U0203","ȃ","a",0xc883,"LATIN SMALL LETTER A WITH INVERTED BREVE"},
{"#U0204","Ȅ","E",0xc884,"LATIN CAPITAL LETTER E WITH DOUBLE GRAVE"},
{"#U0205","ȅ","e",0xc885,"LATIN SMALL LETTER E WITH DOUBLE GRAVE"},
{"#U0206","Ȇ","E",0xc886,"LATIN CAPITAL LETTER E WITH INVERTED BREVE"},
{"#U0207","ȇ","e",0xc887,"LATIN SMALL LETTER E WITH INVERTED BREVE"},
{"#U0208","Ȉ","I",0xc888,"LATIN CAPITAL LETTER I WITH DOUBLE GRAVE"},
{"#U0209","ȉ","i",0xc889,"LATIN SMALL LETTER I WITH DOUBLE GRAVE"},
{"#U020A","Ȋ","I",0xc88a,"LATIN CAPITAL LETTER I WITH INVERTED BREVE"},
{"#U020B","ȋ","i",0xc88b,"LATIN SMALL LETTER I WITH INVERTED BREVE"},
{"#U020C","Ȍ","O",0xc88c,"LATIN CAPITAL LETTER O WITH DOUBLE GRAVE"},
{"#U020D","ȍ","o",0xc88d,"LATIN SMALL LETTER O WITH DOUBLE GRAVE"},
{"#U020E","Ȏ","O",0xc88e,"LATIN CAPITAL LETTER O WITH INVERTED BREVE"},
{"#U020F","ȏ","o",0xc88f,"LATIN SMALL LETTER O WITH INVERTED BREVE"},
{"#U0210","Ȑ","R",0xc890,"LATIN CAPITAL LETTER R WITH DOUBLE GRAVE"},
{"#U0211","ȑ","r",0xc891,"LATIN SMALL LETTER R WITH DOUBLE GRAVE"},
{"#U0212","Ȓ","R",0xc892,"LATIN CAPITAL LETTER R WITH INVERTED BREVE"},
{"#U0213","ȓ","r",0xc893,"LATIN SMALL LETTER R WITH INVERTED BREVE"},
{"#U0214","Ȕ","U",0xc894,"LATIN CAPITAL LETTER U WITH DOUBLE GRAVE"},
{"#U0215","ȕ","u",0xc895,"LATIN SMALL LETTER U WITH DOUBLE GRAVE"},
{"#U0216","Ȗ","U",0xc896,"LATIN CAPITAL LETTER U WITH INVERTED BREVE"},
{"#U0217","ȗ","u",0xc897,"LATIN SMALL LETTER U WITH INVERTED BREVE"},
{"#U0218","Ș","S",0xc898,"LATIN CAPITAL LETTER S WITH COMMA BELOW"},
{"#U0219","ș","s",0xc899,"LATIN SMALL LETTER S WITH COMMA BELOW"},
{"#U021A","Ț","T",0xc89a,"LATIN CAPITAL LETTER T WITH COMMA BELOW"},
{"#U021B","ț","t",0xc89b,"LATIN SMALL LETTER T WITH COMMA BELOW"},
{"#U021C","Ȝ","Y",0xc89c,"LATIN CAPITAL LETTER YOGH"},
{"#U021D","ȝ","y",0xc89d,"LATIN SMALL LETTER YOGH"},
{"#U021E","Ȟ","H",0xc89e,"LATIN CAPITAL LETTER H WITH CARON"},
{"#U021F","ȟ","h",0xc89f,"LATIN SMALL LETTER H WITH CARON"},
{"#U0220","Ƞ","n",0xc8a0,"LATIN CAPITAL LETTER N WITH LONG RIGHT LEG"},
{"#U0221","ȡ","d",0xc8a1,"LATIN SMALL LETTER D WITH CURL"},
{"#U0222","Ȣ","OU",0xc8a2,"LATIN CAPITAL LETTER OU"},
{"#U0223","ȣ","ou",0xc8a3,"LATIN SMALL LETTER OU"},
{"#U0224","Ȥ","Z",0xc8a4,"LATIN CAPITAL LETTER Z WITH HOOK"},
{"#U0225","ȥ","z",0xc8a5,"LATIN SMALL LETTER Z WITH HOOK"},
{"#U0226","Ȧ","A",0xc8a6,"LATIN CAPITAL LETTER A WITH DOT ABOVE"},
{"#U0227","ȧ","a",0xc8a7,"LATIN SMALL LETTER A WITH DOT ABOVE"},
{"#U0228","Ȩ","E",0xc8a8,"LATIN CAPITAL LETTER E WITH CEDILLA"},
{"#U0229","ȩ","e",0xc8a9,"LATIN SMALL LETTER E WITH CEDILLA"},
{"#U022A","Ȫ","O",0xc8aa,"LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON"},
{"#U022B","ȫ","o",0xc8ab,"LATIN SMALL LETTER O WITH DIAERESIS AND MACRON"},
{"#U022C","Ȭ","O",0xc8ac,"LATIN CAPITAL LETTER O WITH TILDE AND MACRON"},
{"#U022D","ȭ","o",0xc8ad,"LATIN SMALL LETTER O WITH TILDE AND MACRON"},
{"#U022E","Ȯ","O",0xc8ae,"LATIN CAPITAL LETTER O WITH DOT ABOVE"},
{"#U022F","ȯ","o",0xc8af,"LATIN SMALL LETTER O WITH DOT ABOVE"},
{"#U0230","Ȱ","O",0xc8b0,"LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON"},
{"#U0231","ȱ","o",0xc8b1,"LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON"},
{"#U0232","Ȳ","Y",0xc8b2,"LATIN CAPITAL LETTER Y WITH MACRON"},
{"#U0233","ȳ","y",0xc8b3,"LATIN SMALL LETTER Y WITH MACRON"},
{"#U0234","ȴ","l",0xc8b4,"LATIN SMALL LETTER L WITH CURL"},
{"#U0235","ȵ","n",0xc8b5,"LATIN SMALL LETTER N WITH CURL"},
{"#U0236","ȶ","t",0xc8b6,"LATIN SMALL LETTER T WITH CURL"},
{"#U0237","ȷ","j",0xc8b7,"LATIN SMALL LETTER DOTLESS J"},
{"#U0238","ȸ","db",0xc8b8,"LATIN SMALL LETTER DB DIGRAPH"},
{"#U0239","ȹ","qp",0xc8b9,"LATIN SMALL LETTER QP DIGRAPH"},
{"#U023A","Ⱥ","A",0xc8ba,"LATIN CAPITAL LETTER A WITH STROKE"},
{"#U023B","Ȼ","C",0xc8bb,"LATIN CAPITAL LETTER C WITH STROKE"},
{"#U023C","ȼ","c",0xc8bc,"LATIN SMALL LETTER C WITH STROKE"},
{"#U023D","Ƚ","L",0xc8bd,"LATIN CAPITAL LETTER L WITH BAR"},
{"#U023E","Ⱦ","T",0xc8be,"LATIN CAPITAL LETTER T WITH DIAGONAL STROKE"},
{"#U023F","ȿ","s",0xc8bf,"LATIN SMALL LETTER S WITH SWASH TAIL"},
{"#U0240","ɀ","z",0xc980,"LATIN SMALL LETTER Z WITH SWASH TAIL"},
{"#U0241","Ɂ","`",0xc981,"LATIN CAPITAL LETTER GLOTTAL STOP"},
{"#U0242","ɂ","`",0xc982,"LATIN SMALL LETTER GLOTTAL STOP"},
{"#U0243","Ƀ","B",0xc983,"LATIN CAPITAL LETTER B WITH STROKE"},
{"#U0244","Ʉ","U",0xc984,"LATIN CAPITAL LETTER U BAR"},
{"#U0245","Ʌ","V",0xc985,"LATIN CAPITAL LETTER TURNED V"},
{"#U0246","Ɇ","E",0xc986,"LATIN CAPITAL LETTER E WITH STROKE"},
{"#U0247","ɇ","e",0xc987,"LATIN SMALL LETTER E WITH STROKE"},
{"#U0248","Ɉ","J",0xc988,"LATIN CAPITAL LETTER J WITH STROKE"},
{"#U0249","ɉ","j",0xc989,"LATIN SMALL LETTER J WITH STROKE"},
{"#U024A","Ɋ","Q",0xc98a,"LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL"},
{"#U024B","ɋ","q",0xc98b,"LATIN SMALL LETTER Q WITH HOOK TAIL"},
{"#U024C","Ɍ","R",0xc98c,"LATIN CAPITAL LETTER R WITH STROKE"},
{"#U024D","ɍ","r",0xc98d,"LATIN SMALL LETTER R WITH STROKE"},
{"#U024E","Ɏ","Y",0xc98e,"LATIN CAPITAL LETTER Y WITH STROKE"},
{"#U024F","ɏ","y",0xc98f,"LATIN SMALL LETTER Y WITH STROKE"},
{"#U0250","ɐ","a",0xc990,"LATIN SMALL LETTER TURNED A"},
{"#U0251","ɑ","a",0xc991,"LATIN SMALL LETTER ALPHA"},
{"#U0252","ɒ","a",0xc992,"LATIN SMALL LETTER TURNED ALPHA"},
{"#U0253","ɓ","b",0xc993,"LATIN SMALL LETTER B WITH HOOK"},
{"#U0254","ɔ","o",0xc994,"LATIN SMALL LETTER OPEN O"},
{"#U0255","ɕ","c",0xc995,"LATIN SMALL LETTER C WITH CURL"},
{"#U0256","ɖ","d",0xc996,"LATIN SMALL LETTER D WITH TAIL"},
{"#U0257","ɗ","d",0xc997,"LATIN SMALL LETTER D WITH HOOK"},
{"#U0258","ɘ","e",0xc998,"LATIN SMALL LETTER REVERSED E"},
{"#U0259","ə","s",0xc999,"LATIN SMALL LETTER SCHWA"},
{"#U025A","ɚ","s",0xc99a,"LATIN SMALL LETTER SCHWA WITH HOOK"},
{"#U025B","ɛ","e",0xc99b,"LATIN SMALL LETTER OPEN E"},
{"#U025C","ɜ","e",0xc99c,"LATIN SMALL LETTER REVERSED OPEN E"},
{"#U025D","ɝ","e",0xc99d,"LATIN SMALL LETTER REVERSED OPEN E WITH HOOK"},
{"#U025E","ɞ","e",0xc99e,"LATIN SMALL LETTER CLOSED REVERSED OPEN E"},
{"#U025F","ɟ","j",0xc99f,"LATIN SMALL LETTER DOTLESS J WITH STROKE"},
{"#U0260","ɠ","g",0xc9a0,"LATIN SMALL LETTER G WITH HOOK"},
{"#U0261","ɡ","g",0xc9a1,"LATIN SMALL LETTER SCRIPT G"},
{"#U0262","ɢ","g",0xc9a2,"LATIN LETTER SMALL CAPITAL G"},
{"#U0263","ɣ","g",0xc9a3,"LATIN SMALL LETTER GAMMA"},
{"#U0264","ɤ","g",0xc9a4,"LATIN SMALL LETTER RAMS HORN"},
{"#U0265","ɥ","h",0xc9a5,"LATIN SMALL LETTER TURNED H"},
{"#U0266","ɦ","h",0xc9a6,"LATIN SMALL LETTER H WITH HOOK"},
{"#U0267","ɧ","h",0xc9a7,"LATIN SMALL LETTER HENG WITH HOOK"},
{"#U0268","ɨ","i",0xc9a8,"LATIN SMALL LETTER I WITH STROKE"},
{"#U0269","ɩ","i",0xc9a9,"LATIN SMALL LETTER IOTA"},
{"#U026A","ɪ","I",0xc9aa,"LATIN LETTER SMALL CAPITAL I"},
{"#U026B","ɫ","l",0xc9ab,"LATIN SMALL LETTER L WITH MIDDLE TILDE"},
{"#U026C","ɬ","l",0xc9ac,"LATIN SMALL LETTER L WITH BELT"},
{"#U026D","ɭ","l",0xc9ad,"LATIN SMALL LETTER L WITH RETROFLEX HOOK"},
{"#U026E","ɮ","lezh",0xc9ae,"LATIN SMALL LETTER LEZH"},
{"#U026F","ɯ","m",0xc9af,"LATIN SMALL LETTER TURNED M"},
{"#U0270","ɰ","m",0xc9b0,"LATIN SMALL LETTER TURNED M WITH LONG LEG"},
{"#U0271","ɱ","m",0xc9b1,"LATIN SMALL LETTER M WITH HOOK"},
{"#U0272","ɲ","n",0xc9b2,"LATIN SMALL LETTER N WITH LEFT HOOK"},
{"#U0273","ɳ","n",0xc9b3,"LATIN SMALL LETTER N WITH RETROFLEX HOOK"},
{"#U0274","ɴ","N",0xc9b4,"LATIN LETTER SMALL CAPITAL N"},
{"#U0275","ɵ","o",0xc9b5,"LATIN SMALL LETTER BARRED O"},
{"#U0276","ɶ","OE",0xc9b6,"LATIN LETTER SMALL CAPITAL OE"},
{"#U0277","ɷ","o",0xc9b7,"LATIN SMALL LETTER CLOSED OMEGA"},
{"#U0278","ɸ","p",0xc9b8,"LATIN SMALL LETTER PHI"},
{"#U0279","ɹ","r",0xc9b9,"LATIN SMALL LETTER TURNED R"},
{"#U027A","ɺ","r",0xc9ba,"LATIN SMALL LETTER TURNED R WITH LONG LEG"},
{"#U027B","ɻ","r",0xc9bb,"LATIN SMALL LETTER TURNED R WITH HOOK"},
{"#U027C","ɼ","r",0xc9bc,"LATIN SMALL LETTER R WITH LONG LEG"},
{"#U027D","ɽ","r",0xc9bd,"LATIN SMALL LETTER R WITH TAIL"},
{"#U027E","ɾ","r",0xc9be,"LATIN SMALL LETTER R WITH FISHHOOK"},
{"#U027F","ɿ","r",0xc9bf,"LATIN SMALL LETTER REVERSED R WITH FISHHOOK"},
{"#U0280","ʀ","R",0xca80,"LATIN LETTER SMALL CAPITAL R"},
{"#U0281","ʁ","R",0xca81,"LATIN LETTER SMALL CAPITAL INVERTED R"},
{"#U0282","ʂ","d",0xca82,"LATIN SMALL LETTER S WITH HOOK"},
{"#U0283","ʃ","esh",0xca83,"LATIN SMALL LETTER ESH"},
{"#U0284","ʄ","j",0xca84,"LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK"},
{"#U0285","ʅ","esh",0xca85,"LATIN SMALL LETTER SQUAT REVERSED ESH"},
{"#U0286","ʆ","esh",0xca86,"LATIN SMALL LETTER ESH WITH CURL"},
{"#U0287","ʇ","t",0xca87,"LATIN SMALL LETTER TURNED T"},
{"#U0288","ʈ","t",0xca88,"LATIN SMALL LETTER T WITH RETROFLEX HOOK"},
{"#U0289","ʉ","u",0xca89,"LATIN SMALL LETTER U BAR"},
{"#U028A","ʊ","u",0xca8a,"LATIN SMALL LETTER UPSILON"},
{"#U028B","ʋ","v",0xca8b,"LATIN SMALL LETTER V WITH HOOK"},
{"#U028C","ʌ","v",0xca8c,"LATIN SMALL LETTER TURNED V"},
{"#U028D","ʍ","w",0xca8d,"LATIN SMALL LETTER TURNED W"},
{"#U028E","ʎ","y",0xca8e,"LATIN SMALL LETTER TURNED Y"},
{"#U028F","ʏ","Y",0xca8f,"LATIN LETTER SMALL CAPITAL Y"},
{"#U0290","ʐ","z",0xca90,"LATIN SMALL LETTER Z WITH RETROFLEX HOOK"},
{"#U0291","ʑ","z",0xca91,"LATIN SMALL LETTER Z WITH CURL"},
{"#U0292","ʒ","ezh",0xca92,"LATIN SMALL LETTER EZH"},
{"#U0293","ʓ","ezh",0xca93,"LATIN SMALL LETTER EZH WITH CURL"},
{"#U0294","ʔ","`",0xca94,"LATIN LETTER GLOTTAL STOP"},
{"#U0295","ʕ","s",0xca95,"LATIN LETTER PHARYNGEAL VOICED FRICATIVE"},
{"#U0296","ʖ","`",0xca96,"LATIN LETTER INVERTED GLOTTAL STOP"},
{"#U0297","ʗ","C",0xca97,"LATIN LETTER STRETCHED C"},
{"#U0298","ʘ","O",0xca98,"LATIN LETTER BILABIAL CLICK"},
{"#U0299","ʙ","B",0xca99,"LATIN LETTER SMALL CAPITAL B"},
{"#U029A","ʚ","e",0xca9a,"LATIN SMALL LETTER CLOSED OPEN E"},
{"#U029B","ʛ","G",0xca9b,"LATIN LETTER SMALL CAPITAL G WITH HOOK"},
{"#U029C","ʜ","H",0xca9c,"LATIN LETTER SMALL CAPITAL H"},
{"#U029D","ʝ","j",0xca9d,"LATIN SMALL LETTER J WITH CROSSED-TAIL"},
{"#U029E","ʞ","k",0xca9e,"LATIN SMALL LETTER TURNED K"},
{"#U029F","ʟ","L",0xca9f,"LATIN LETTER SMALL CAPITAL L"},
{"#U02A0","ʠ","q",0xcaa0,"LATIN SMALL LETTER Q WITH HOOK"},
{"#U02A1","ʡ","`",0xcaa1,"LATIN LETTER GLOTTAL STOP WITH STROKE"},
{"#U02A2","ʢ","`",0xcaa2,"LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE"},
{"#U02A3","ʣ","dz",0xcaa3,"LATIN SMALL LETTER DZ DIGRAPH"},
{"#U02A4","ʤ","dezh",0xcaa4,"LATIN SMALL LETTER DEZH DIGRAPH"},
{"#U02A5","ʥ","dz",0xcaa5,"LATIN SMALL LETTER DZ DIGRAPH WITH CURL"},
{"#U02A6","ʦ","ts",0xcaa6,"LATIN SMALL LETTER TS DIGRAPH"},
{"#U02A7","ʧ","tesh",0xcaa7,"LATIN SMALL LETTER TESH DIGRAPH"},
{"#U02A8","ʨ","tc",0xcaa8,"LATIN SMALL LETTER TC DIGRAPH WITH CURL"},
{"#U02A9","ʩ","feng",0xcaa9,"LATIN SMALL LETTER FENG DIGRAPH"},
{"#U02AA","ʪ","ls",0xcaaa,"LATIN SMALL LETTER LS DIGRAPH"},
{"#U02AB","ʫ","lz",0xcaab,"LATIN SMALL LETTER LZ DIGRAPH"},
{"#U02AC","ʬ","ww",0xcaac,"LATIN LETTER BILABIAL PERCUSSIVE"},
{"#U02AD","ʭ","dd",0xcaad,"LATIN LETTER BIDENTAL PERCUSSIVE"},
{"#U02AE","ʮ","h",0xcaae,"LATIN SMALL LETTER TURNED H WITH FISHHOOK"},
{"#U02AF","ʯ","h",0xcaaf,"LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL"},
{NULL,NULL,NULL,0,NULL}
};
