/*
  Data for Gaussian integration on a sphere
  The first 12 points are vertices of eikosahedron
  then 20 vertices of dodekahedron.
  Ordered so that odd-index and even-index vectors are of opposite signs
  vector should be real[3], where real=float or double
History:
  1995 first version
  2021 polished ({} added) to suppress strict compiler warnings
*/

struct sphint_s {
  vector n; /* unit vector on a sphere */
  real w;   /* weight (normalized to unity sum) */
  } sphint[32]= {
{{ 0.00000000000000000, 0.00000000000000000, 1.00000000000000000},1.0 /33.6},
{{ 0.00000000000000000, 0.00000000000000000,-1.00000000000000000},1.0 /33.6},
{{ 0.27639320225002103, 0.85065080835203993, 0.44721359549995794},1.0 /33.6},
{{-0.27639320225002103,-0.85065080835203993,-0.44721359549995794},1.0 /33.6},
{{ 0.27639320225002103,-0.85065080835203993, 0.44721359549995794},1.0 /33.6},
{{-0.27639320225002103, 0.85065080835203993,-0.44721359549995794},1.0 /33.6},
{{ 0.72360679774997897, 0.52573111211913361,-0.44721359549995794},1.0 /33.6},
{{-0.72360679774997897,-0.52573111211913361, 0.44721359549995794},1.0 /33.6},
{{ 0.72360679774997897,-0.52573111211913361,-0.44721359549995794},1.0 /33.6},
{{-0.72360679774997897, 0.52573111211913361, 0.44721359549995794},1.0 /33.6},
{{ 0.89442719099991588, 0.00000000000000000, 0.44721359549995794},1.0 /33.6},
{{-0.89442719099991588,-0.00000000000000000,-0.44721359549995794},1.0 /33.6},
{{ 0.18759247408507990, 0.57735026918962576,-0.79465447229176612},1.08/33.6},
{{-0.18759247408507990,-0.57735026918962576, 0.79465447229176612},1.08/33.6},
{{ 0.18759247408507990,-0.57735026918962576,-0.79465447229176612},1.08/33.6},
{{-0.18759247408507990, 0.57735026918962576, 0.79465447229176612},1.08/33.6},
{{ 0.30353099910334311, 0.93417235896271570,-0.18759247408507990},1.08/33.6},
{{-0.30353099910334311,-0.93417235896271570, 0.18759247408507990},1.08/33.6},
{{ 0.30353099910334311,-0.93417235896271570,-0.18759247408507990},1.08/33.6},
{{-0.30353099910334311, 0.93417235896271570, 0.18759247408507990},1.08/33.6},
{{ 0.49112347318842301, 0.35682208977308993, 0.79465447229176612},1.08/33.6},
{{-0.49112347318842301,-0.35682208977308993,-0.79465447229176612},1.08/33.6},
{{ 0.49112347318842301,-0.35682208977308993, 0.79465447229176612},1.08/33.6},
{{-0.49112347318842301, 0.35682208977308993,-0.79465447229176612},1.08/33.6},
{{ 0.60706199820668622, 0.00000000000000000,-0.79465447229176612},1.08/33.6},
{{-0.60706199820668622, 0.00000000000000000, 0.79465447229176612},1.08/33.6},
{{ 0.79465447229176612, 0.57735026918962576, 0.18759247408507990},1.08/33.6},
{{-0.79465447229176612,-0.57735026918962576,-0.18759247408507990},1.08/33.6},
{{ 0.79465447229176612,-0.57735026918962576, 0.18759247408507990},1.08/33.6},
{{-0.79465447229176612, 0.57735026918962576,-0.18759247408507990},1.08/33.6},
{{ 0.98224694637684602, 0.00000000000000000,-0.18759247408507990},1.08/33.6},
{{-0.98224694637684602, 0.00000000000000000, 0.18759247408507990},1.08/33.6}
};
#if 0
/* centres of dodekahedron or eikosahedron edges */
{ 0.00000000000000000, 1.00000000000000000, 0.00000000000000000},
{-0.00000000000000000,-1.00000000000000000, 0.00000000000000000},
{ 0.16245984811645316, 0.50000000000000000, 0.85065080835203993},
{-0.16245984811645316,-0.50000000000000000,-0.85065080835203993},
{ 0.16245984811645316,-0.50000000000000000, 0.85065080835203993},
{-0.16245984811645316, 0.50000000000000000,-0.85065080835203993},
{ 0.26286555605956680, 0.80901699437494742,-0.52573111211913361},
{-0.26286555605956680,-0.80901699437494742, 0.52573111211913361},
{ 0.26286555605956680,-0.80901699437494742,-0.52573111211913361},
{-0.26286555605956680, 0.80901699437494742, 0.52573111211913361},
{ 0.42532540417601997, 0.30901699437494742,-0.85065080835203993},
{-0.42532540417601997,-0.30901699437494742, 0.85065080835203993},
{ 0.42532540417601997,-0.30901699437494742,-0.85065080835203993},
{-0.42532540417601997, 0.30901699437494742, 0.85065080835203993},
{ 0.52573111211913361, 0.00000000000000000, 0.85065080835203993},
{-0.52573111211913361, 0.00000000000000000,-0.85065080835203993},
{ 0.58778525229247313, 0.80901699437494742, 0.00000000000000000},
{-0.58778525229247313,-0.80901699437494742, 0.00000000000000000},
{ 0.58778525229247313,-0.80901699437494742, 0.00000000000000000},
{-0.58778525229247313, 0.80901699437494742, 0.00000000000000000},
{ 0.68819096023558677, 0.50000000000000000, 0.52573111211913361},
{-0.68819096023558677,-0.50000000000000000,-0.52573111211913361},
{ 0.68819096023558677,-0.50000000000000000, 0.52573111211913361},
{-0.68819096023558677, 0.50000000000000000,-0.52573111211913361},
{ 0.85065080835203993, 0.00000000000000000,-0.52573111211913361},
{-0.85065080835203993, 0.00000000000000000, 0.52573111211913361},
{ 0.95105651629515357, 0.30901699437494742, 0.00000000000000000},
{-0.95105651629515357,-0.30901699437494742, 0.00000000000000000},
{ 0.95105651629515357,-0.30901699437494742, 0.00000000000000000},
{-0.95105651629515357, 0.30901699437494742, 0.00000000000000000},
#endif
