function [x, y] = ODEsiteNewton(n, f, df2, df3, a, b, alpha1,alpha2, beta1,beta2, gamma1,gamma2, y_init, N_eps, N_maxiter)
% Funkce ODEsiteNewton resi obycejnou diferencialni 
% rovnici druheho radu y''=f(x,y,y') na intervalu [a, b]
% metodou siti. Nelinearni algebraicke rovnice se resi 
% Newtonovou metodou
%
% f .. funkce prave strany
% df2 = df/dy .. derivace f podle y
% df3 = df/dy'.. derivace f podle y' 
%  
% okrajove podminky:
% alpha1*y(a) + beta1*y'(a) = gamma1
% alpha2*y(b) + beta2*y'(b) = gamma2
%
% y_init    .. pocatecni nastrel reseni pro Newtonovu metodu
% N_eps     .. stopping kriterium pro Newtonovu metodu
% N_maxiter .. maximalni pocet Newtonovych iteraci

h = (b-a)/n;
y_old = [ ];
y_old = y_init;
y_old(1) = (gamma1 - 4*beta1/(2*h)*y_old(2) + beta1/(2*h)*y_old(3))/(alpha1 - 3*beta1/(2*h));
y_old(n+1) = (gamma2 + 4*beta2/(2*h)*y_old(n) - beta2/(2*h)*y_old(n-1))/(alpha2 + 3*beta2/(2*h));

for i = 1:n+1
  x(i) = a + (i-1)*h;
end
y = [ ];

error = N_eps+1;
k = 0;
fprintf('Iterace Newtonovy metody:\n');
while error >= N_eps && k <= N_maxiter
  F(1) = - ( 1/(h*h)*(y_old(1) - 2*y_old(2) + y_old(3)) - f(x(2),y_old(2),(y_old(3) - y_old(1))/(2*h)));
  a(1) = 0;
  b(1) = - 2/(h*h) - df2(x(2),y_old(2),(y_old(3) - y_old(1))/(2*h)) - 1/(h*h)*(4*beta1/(2*h))/(alpha1 - 3*beta1/(2*h)) - df3(x(2),y_old(2),(y_old(3) - y_old(1))/(2*h))* 1/(2*h)*(4*beta1/(2*h))/(alpha1 - 3*beta1/(2*h));
  c(1) =   1/(h*h) - 1/(2*h) * df3(x(2),y_old(2),(y_old(3) - y_old(1))/(2*h)) + 1/(h*h)*(beta1/(2*h))/(alpha1 - 3*beta1/(2*h)) - df3(x(2),y_old(2),(y_old(3) - y_old(1))/(2*h))* 1/(2*h)*(  beta1/(2*h))/(alpha1 - 3*beta1/(2*h));
  
  for i = 2:n-2	
    F(i) = -( 1/(h*h)*(y_old(i) - 2*y_old(i+1) + y_old(i+2)) - f(x(i+1),y_old(i+1),(y_old(i+2) - y_old(i))/(2*h)));
    a(i) = 1/(h*h) + 1/(2*h) * df3(x(i+1),y_old(i+1),(y_old(i+2) - y_old(i))/(2*h));
    b(i) = -2/(h*h) - df2(x(i+1),y_old(i+1),(y_old(i+2) - y_old(i))/(2*h));
    c(i) = 1/(h*h) - 1/(2*h) * df3(x(i+1),y_old(i+1),(y_old(i+2) - y_old(i))/(2*h));
  end  

  F(n-1) = -(1/(h*h)*(y_old(n-1) - 2*y_old(n) + y_old(n+1)) - f(x(n),y_old(n),(y_old(n+1) - y_old(n-1))/(2*h)));
  a(n-1) =   1/(h*h) + 1/(2*h) * df3(x(n),y_old(n),(y_old(n+1) - y_old(n-1))/(2*h)) - 1/(h*h)*(beta2/(2*h))/(alpha2 + 3*beta2/(2*h)) + df3(x(n),y_old(n),(y_old(n+1) - y_old(n-1))/(2*h))* 1/(2*h)*(  beta2/(2*h))/(alpha2 + 3*beta2/(2*h));
  b(n-1) = - 2/(h*h) - df2(x(n),y_old(n),(y_old(n+1) - y_old(n-1))/(2*h)) + 1/(h*h)*(4*beta2/(2*h))/(alpha2 + 3*beta2/(2*h)) - df3(x(n),y_old(n),(y_old(n+1) - y_old(n-1))/(2*h))* 1/(2*h)*(4*beta2/(2*h))/(alpha2 + 3*beta2/(2*h));
  c(n-1) = 0;

  % reseni soustavy s Jacobianem (tridiagonalni matice)
  delta_y = TriDiagonalSolve(a,b,c,F);
  
  % vypocet dalsi Newtonovy iterace
  y_new = [ ];
  for i = 2:n	
    y_new(i) = y_old(i) + delta_y(i-1);
  end
  y_new(1) = (gamma1 - 4*beta1/(2*h)*y_new(2) + beta1/(2*h)*y_new(3))/(alpha1 - 3*beta1/(2*h));
  y_new(n+1) = (gamma2 + 4*beta2/(2*h)*y_new(n) - beta2/(2*h)*y_new(n-1))/(alpha2 + 3*beta2/(2*h));
  
  % euklidovska norma dvou Newtonovych iteraci
  error = norm(y_new - y_old);
  k = k + 1;
  fprintf(1,'k = %d, ',k);
  fprintf(1,'error = %16.8e\n',error);
  y_old = y_new;
end 

if error < N_eps
  y = y_new;
  fprintf('Reseni: \n');
  fprintf('   x      y(x)\n');
  for i = 1:(n+1)
      fprintf('%5.3f, %10.6f\n',x(i),y(i));
  end
else
  fprintf('Metoda nekonverguje. Vycerpan maximalni pocet iteraci Newtonovy metody\n');
end


end



