function x = TriDiagonalSolve(a,b,c,d)
% Reseni soustavy linearnich rovnic s tridiagonalni matici
% Ukladaji se jen diagonaly a, b, c:
% vector a = (0,   a_2,...,a_{n-1}, a_n) - dolni diagonala
% vector b = (b_1, b_2,...,b_{n-1}, b_n) - hlavni diagonala
% vector c = (c_1, c_2,...,c_{n-1}, 0)   - horni diagonala
% vector d = (d_1, d_2,...,d_{n-1}, d_n) - vector pravych stran

n = length(d);
x = zeros(n,1);

c(1) = c(1)/b(1);
d(1) = d(1)/b(1);
b(1) = 1;

for i=2:n
    % eliminace v i-tem radku
    b(i) = b(i)-c(i-1)*a(i);
    d(i) = d(i)-d(i-1)*a(i);
    a(i) = 0;
    % vydeleni radku a(i)
    c(i) = c(i)/b(i);
    d(i) = d(i)/b(i);
    b(i) = 1;
end

% zpetna substituce:

x(n) = d(n);
for i=n-1:-1:1
    x(i) = d(i)-c(i)*x(i+1);
end 

end
