% y''= -a/x y' +phi^2 y^n, y'(0)=0, y(1)=1 

% interval kde resim rovnici
a = 0; b = 1; 

% okrajove podminky
alpha1 = 0;
alpha2 = 1;
beta1 = 1;
beta2 = 0;
gamma1 = 0;
gamma2 = 1;

n = 20; % pocet dilku site
h = (b-a)/n; 

% pocatecni nastrel pro Newtonovu metodu
y_init = [ ];
for i = 1:n+1;
    y_init(i) = 1.0;
end    

% parametry pro Newtonovy metodu
N_eps = 1e-6;
N_maxiter = 50;

fprintf('---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 0, a = 1, phi = 1\n');

f = inline('-1.0/x * dy + 1.0','x','y','dy');
df2 = inline('0','x','y','dy');
df3 = inline('-1.0/x','x','y','dy');

[x, y] = ODEsiteNewton(n, f, df2, df3, a, b, alpha1,alpha2, beta1,beta2, gamma1,gamma2, y_init, N_eps, N_maxiter);

% efektivni faktor:
eta = (1.0 + 1.0)/1.0 * (y(n)-y(n-1))/h;
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    figure
    plot (x,y,'DisplayName','n = 0, a = 1, phi = 1')
    title('Izotermni vnitrni difuze v poreznim katalyzatoru')
    xlabel('x')
    ylabel('y(x)')
    legend('show','Location','northwest');
end

fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 2, phi = 1\n');

f = inline('-2.0/x * dy + y','x','y','dy');
df2 = inline('1.0','x','y','dy');
df3 = inline('-2.0/x','x','y','dy');

[x, y] = ODEsiteNewton(n, f, df2, df3, a, b, alpha1,alpha2, beta1,beta2, gamma1,gamma2, y_init, N_eps, N_maxiter);

% efektivni faktor:
eta = (2.0 + 1.0)/1.0 * (y(n)-y(n-1))/h;
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    figure
    plot (x,y,'DisplayName','n = 1, a = 2, phi = 1')
    hold on;
end

fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 2, phi = 2\n');

f = inline('-2.0/x * dy + 4.0 * y','x','y','dy');
df2 = inline('4.0','x','y','dy');
df3 = inline('-2.0/x','x','y','dy');

[x, y] = ODEsiteNewton(n, f, df2, df3, a, b, alpha1,alpha2, beta1,beta2, gamma1,gamma2, y_init, N_eps, N_maxiter);

% efektivni faktor:
eta = (2.0 + 1.0)/4.0 * (y(n)-y(n-1))/h;
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    plot (x,y,'DisplayName','n = 1, a = 2, phi = 2')
    hold on;
end

fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 2, phi = 4\n');

f = inline('-2.0/x * dy + 16.0 * y','x','y','dy');
df2 = inline('16.0','x','y','dy');
df3 = inline('-2.0/x','x','y','dy');

[x, y] = ODEsiteNewton(n, f, df2, df3, a, b, alpha1,alpha2, beta1,beta2, gamma1,gamma2, y_init, N_eps, N_maxiter);

% efektivni faktor:
eta = (2.0 + 1.0)/16.0 * (y(n)-y(n-1))/h;
fprintf('Efektivni faktor: %f\n', eta);

if (~isempty(y)) 
    plot (x,y,'DisplayName','n = 1, a = 2, phi = 4')
    title('Izotermni vnitrni difuze v poreznim katalyzatoru')
    xlabel('x')
    ylabel('y(x)')
    legend('show','Location','northwest');
end

fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 0, phi = 1\n');

f = inline('y','x','y','dy');
df2 = inline('1.0','x','y','dy');
df3 = inline('0.0','x','y','dy');

[x, y] = ODEsiteNewton(n, f, df2, df3, a, b, alpha1,alpha2, beta1,beta2, gamma1,gamma2, y_init, N_eps, N_maxiter);

% efektivni faktor:
eta = (1.0)/1.0 * (y(n)-y(n-1))/h;
fprintf('Efektivni faktor: %f\n', eta);

if (~isempty(y)) 
    figure
    plot (x,y,'DisplayName','n = 1, a = 0, phi = 1')
    hold on;
end

fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 0, phi = 2\n');

f = inline('4.0 * y','x','y','dy');
df2 = inline('4.0','x','y','dy');
df3 = inline('0.0','x','y','dy');

[x, y] = ODEsiteNewton(n, f, df2, df3, a, b, alpha1,alpha2, beta1,beta2, gamma1,gamma2, y_init, N_eps, N_maxiter);

% efektivni faktor:
eta = (1.0)/4.0 * (y(n)-y(n-1))/h;
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    plot (x,y,'DisplayName','n = 1, a = 0, phi = 2')
    hold on;
end

fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 0, phi = 4\n');

f = inline('16.0 * y','x','y','dy');
df2 = inline('16.0','x','y','dy');
df3 = inline('0.0','x','y','dy');

[x, y] = ODEsiteNewton(n, f, df2, df3, a, b, alpha1,alpha2, beta1,beta2, gamma1,gamma2, y_init, N_eps, N_maxiter);

% efektivni faktor:
eta = (1.0)/16.0 * (y(n)-y(n-1))/h;
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y))
    plot (x,y,'DisplayName','n = 1, a = 0, phi = 4')
    title('Izotermni vnitrni difuze v poreznim katalyzatoru')
    xlabel('x')
    ylabel('y(x)')
    legend('show','Location','northwest');
end

