% 1/Pe * u'' - u' - R * u^2 = 0, 
% u(0) - 1/Pe * u'(0) = 1, 
% u'(1) = 0

% Pe = 6, R = 2
n = 20;
f = inline('6 * du + 2 * 6 * u^2','x','u','du');
df2 = inline('2 * 6 * 2 * u','x','u','du');
df3 = inline('6','x','u','du');
a = 0; b = 1;
alpha1 = 1;
alpha2 = 0;
beta1 = -1.0/6.0;
beta2 = 1;
gamma1 = 1;
gamma2 = 0;
u_init = [];
for i = 1:n+1;
    u_init(i) = 1.0;
end    

N_eps = 1e-6;
N_maxiter = 50;
[x, u] = ODEsiteNewton(n, f, df2, df3, a, b, alpha1,alpha2, beta1,beta2, gamma1,gamma2, u_init, N_eps, N_maxiter);
if (~isempty(u)) 
    figure
    plot (x,u)
    title('Axialni sdileni hmoty v trubkovem homogennim reaktoru')
    xlabel('x')
    ylabel('u(x)')
end
