function [y, eta] = MetodaStrelby(odr_var, a, b, alpha1,alpha2, beta1,beta2,gamma1,gamma2, eta_0, eps, maxiter, Lx)
% Reseni soustavy dvou obycejnych diferencialnich rovnic prvniho radu na
% intervalu [a, b] metodou strelby.
% odr_var ... variacni rovnice
% alpha1*y1(a) + beta1*y2(a) = gamma1 ... pocatecni podminka
% alpha2*y1(b) + beta2*y2(b) = gamma2 ... koncova podminka
% eta_0 ... pocatecni odhad volene pocatecni podminky
% eps ... mez konvergence newtonovy metody
% maxiter ... maximalni pocet iteraci newtonovy metody

eta_old = eta_0;
delta = eps+1;
k = 0;
eta = 0;
fprintf(1,'k = %d, eta = %16.8e\n',k,eta_0);

while delta >= eps && k <= maxiter
    ic = [0,0,0,0];
    if (abs(beta1) < 1e-8) 
        ic(2) = eta_old; ic(4) = 1;
        ic(1) = (gamma1-beta1*eta_old)/alpha1;
        ic(3) = -beta1/alpha1;
    else
        ic(1) = eta_old; ic(3) = 1;
        ic(2) = (gamma1-alpha1*eta_old)/beta1;
        ic(4) = -alpha1/beta1;
    end
    
    [~,y] = ode45(odr_var, Lx, ic);

    phi = alpha2*y(end,1)+ beta2*y(end,2)-gamma2;
    phi_der = alpha2*y(end,3)+ beta2*y(end,4);

    eta_new = eta_old - phi/phi_der;
    delta = abs(eta_new - eta_old);
    k = k + 1;
    fprintf(1,'k = %d, eta = %16.8e, delta = %16.8e\n',k,eta_new,delta);
    eta_old = eta_new;
end

if ((delta < eps) && (length(Lx) == length(y(:,1))))
    eta = eta_new;

    ic = [0,0,0,0];
    if (abs(beta1) < 1e-8) 
        ic(2) = eta_old; ic(4) = 1;
        ic(1) = (gamma1-beta1*eta_old)/alpha1;
        ic(3) = -beta1/alpha1;
    else
        ic(1) = eta_old; ic(3) = 1;
        ic(2) = (gamma1-alpha1*eta_old)/beta1;
        ic(4) = -alpha1/beta1;
    end

    [~,y] = ode45(odr_var, Lx, ic);
    
    fprintf('Reseni: \n');
    fprintf('   x       y1(x)      y2(x)\n');
    for i = 1:(length(Lx))
      fprintf('%5.3f, %10.6f, %10.6f\n',Lx(i),y(i,1),y(i,2));
    end

else
    fprintf('Metoda nekonverguje. Vycerpan maximalni pocet iteraci Newtonovy metody\n');
    y = [];
end 

end
