% y''= -a/x y' +phi^2 y^n, y'(0)=0, y(1)=1 

a = 0; b = 1; % interval kde resim rovnici

% okrajove podminky
alpha1 = 0;
alpha2 = 1;
beta1 = 1;
beta2 = 0;
gamma1 = 0;
gamma2 = 1;

% parametry pro Newtonovu metodu
eps = 1e-6;
maxiter = 100;

Lx = linspace(a,b,20);

fprintf('---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 0, a = 1, phi = 1\n');

% nastrel pocatecni podminky
eta_0 = 1;
[y, eta] = MetodaStrelby(@ap1_var1,a,b,alpha1,alpha2,beta1,beta2,gamma1,gamma2,eta_0,eps,maxiter,Lx);

eta = (1 + 1)/1^2 * y(end,2);
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    figure
    plot (Lx, y(:,1),'DisplayName','n = 0, a = 1, phi = 1')
    title('Izotermni vnitrni difuze v poreznim katalyzatoru')
    xlabel('x')
    ylabel('y(x)')
    legend('show','Location','northwest');
end

fprintf('---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 2, phi = 1\n');
eta_0 = 1.0;

[y, eta] = MetodaStrelby(@ap1_var2,a,b,alpha1,alpha2,beta1,beta2,gamma1,gamma2,eta_0,eps,maxiter,Lx);

eta = (2 + 1)/1.0 * y(end,2);
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    figure
    plot (Lx, y(:,1),'DisplayName','n = 1, a = 2, phi = 1')
    hold on
end
  
fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 2, phi = 2\n');

eta_0 = 1.0;
[y, eta] = MetodaStrelby(@ap1_var3,a,b,alpha1,alpha2,beta1,beta2,gamma1,gamma2,eta_0,eps,maxiter,Lx);

% efektivni faktor:
eta = (2.0 + 1.0)/4.0 * y(end,2);
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    plot (Lx,y(:,1),'DisplayName','n = 1, a = 2, phi = 2')
    hold on;
end

fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 2, phi = 4\n');
eta_0 = 1.0;

[y, eta] = MetodaStrelby(@ap1_var4,a,b,alpha1,alpha2,beta1,beta2,gamma1,gamma2,eta_0,eps,maxiter,Lx);

eta = (2 + 1)/16.0 * y(end,2);
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    plot (Lx, y(:,1),'DisplayName','n = 1, a = 2, phi = 1')
    title('Izotermni vnitrni difuze v poreznim katalyzatoru')
    xlabel('x')
    ylabel('y(x)')
    legend('show','Location','northwest');
end

fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 0, phi = 1\n');
eta_0 = 1.0;

[y, eta] = MetodaStrelby(@ap1_var5,a,b,alpha1,alpha2,beta1,beta2,gamma1,gamma2,eta_0,eps,maxiter,Lx);

eta = (0 + 1)/1.0 * y(end,2);
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    figure
    plot (Lx, y(:,1),'DisplayName','n = 1, a = 0, phi = 1')
    hold on
end
  
fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 0, phi = 2\n');

eta_0 = 1.0;
[y, eta] = MetodaStrelby(@ap1_var6,a,b,alpha1,alpha2,beta1,beta2,gamma1,gamma2,eta_0,eps,maxiter,Lx);

% efektivni faktor:
eta = (0 + 1.0)/4.0 * y(end,2);
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    plot (Lx,y(:,1),'DisplayName','n = 1, a = 0, phi = 2')
    hold on;
end

fprintf('\n---------------------------------------------------------------\n');
fprintf('Volba parametru: n = 1, a = 0, phi = 4\n');
eta_0 = 1.0;

[y, eta] = MetodaStrelby(@ap1_var7,a,b,alpha1,alpha2,beta1,beta2,gamma1,gamma2,eta_0,eps,maxiter,Lx);

eta = (0 + 1)/16.0 * y(end,2);
fprintf('Efektivni faktor: %f\n', eta);
if (~isempty(y)) 
    plot (Lx, y(:,1),'DisplayName','n = 1, a = 0, phi = 1')
    title('Izotermni vnitrni difuze v poreznim katalyzatoru')
    xlabel('x')
    ylabel('y(x)')
    legend('show','Location','northwest');
end



   
  