% 1/Pe * u'' - u' - R * u^2 = 0, 
% u(0) - 1/Pe * u'(0) = 1, 
% u'(1) = 0

% Pe = 6, R = 2
Pe = 6;

a = 0;
b = 1;

alpha1 = 1;
alpha2 = 0;
beta1 = -1/Pe;
beta2 = 1;
gamma1 = 1;
gamma2 = 0;

eps = 1e-6;
maxiter = 100;
Lx = linspace(a,b,20);

eta_0 = 0.6;
[u, eta] = MetodaStrelby(@ap2_var,a,b,alpha1,alpha2,beta1,beta2,gamma1,gamma2,eta_0,eps,maxiter,Lx);

if (~isempty(u)) 
    figure
    plot (Lx, u(:,1))
    title('Axialni sdileni hmoty v trubkovem homogennim reaktoru')
    xlabel('x')
    ylabel('u(x)')
end

  